% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{get_similar_attribute_values_individually.flat_table}
\alias{get_similar_attribute_values_individually.flat_table}
\alias{get_similar_attribute_values_individually}
\alias{get_similar_attribute_values_individually.star_database}
\title{Get similar values for individual attributes}
\usage{
\method{get_similar_attribute_values_individually}{flat_table}(
  db,
  name = NULL,
  attributes = NULL,
  exclude_numbers = FALSE,
  col_as_vector = NULL
)

get_similar_attribute_values_individually(
  db,
  name,
  attributes,
  exclude_numbers,
  col_as_vector
)

\method{get_similar_attribute_values_individually}{star_database}(
  db,
  name = NULL,
  attributes = NULL,
  exclude_numbers = FALSE,
  col_as_vector = NULL
)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A vector of strings, dimension names.}

\item{attributes}{A vector of strings, attribute names.}

\item{exclude_numbers}{A boolean, exclude numbers from comparison.}

\item{col_as_vector}{A string, name of the column to include a vector of values.}
}
\value{
A vector of \code{tibble} objects with similar instances.
}
\description{
Get sets of attribute values for individual attributes that differ only by
tildes, spaces, or punctuation marks. If no attributes are indicated, all are
considered.
}
\details{
For star databases, if no dimension name is indicated, all dimensions are
considered.

You can indicate that the numbers are ignored to make the comparison.

If a name is indicated in the \code{col_as_vector} parameter, it includes a column
with the data in vector form to be used in other functions.
}
\examples{

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_similar_attribute_values_individually(name = c("where", "when"))

instances <- star_database(mrs_cause_schema, ft_num) |>
  get_similar_attribute_values_individually()

ft <- flat_table('iris', iris)
ft$table$Species[20] <- "se.Tosa."
ft$table$Species[60] <- "Versicolor"
instances <- ft |>
  get_similar_attribute_values_individually()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_attribute_names.flat_table}()},
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
