% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R
\name{as_star_database}
\alias{as_star_database}
\alias{as_star_database.flat_table}
\title{Get a star database from a flat table}
\usage{
as_star_database(ft, schema)

\method{as_star_database}{flat_table}(ft, schema)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{schema}{A \code{star_schema} object.}
}
\value{
A \code{star_database} object.
}
\description{
Obtain a star database from the flat table and a star schema.
}
\examples{

db <- flat_table('ft_num', ft_num) |>
  as_star_database(mrs_cause_schema)

}
\seealso{
\code{\link{star_database}}

Other flat table definition functions: 
\code{\link{flat_table}()},
\code{\link{get_table}()},
\code{\link{get_unknown_value_defined}()},
\code{\link{get_unknown_values}()},
\code{\link{read_flat_table_file}()},
\code{\link{read_flat_table_folder}()}
}
\concept{flat table definition functions}
