% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_tomic}
\alias{filter_tomic}
\title{Filter T* Omics}
\usage{
filter_tomic(
  tomic,
  filter_type,
  filter_table,
  filter_value,
  filter_variable = NULL
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{filter_type}{\describe{
  \item{category}{filter filter_variable to categories specified in
    filter_value}
  \item{range}{filter filter_variable to using the range (i.e., lower and
    upper limit) provided in filter_value}
  \item{apply}{a quosure as a \code{filter_value} to a table of interest}
}}

\item{filter_table}{table where the filter should be applied}

\item{filter_value}{values to filter based on}

\item{filter_variable}{variable to apply the filter to}
}
\value{
A \code{tomic} object where a subset of features, samples or
  measurmenets have been filtered.
}
\description{
Filter a tidy or triple omic to entries of interest.
}
\examples{

filter_tomic(
  brauer_2008_triple,
  filter_type = "category",
  filter_table = "features",
  filter_variable = "BP",
  filter_value = c("biological process unknown", "vacuolar acidification")
)

filter_tomic(
  brauer_2008_triple,
  filter_type = "category",
  filter_table = "samples",
  filter_variable = "DR",
  filter_value = 0.05
)

filter_tomic(
  brauer_2008_tidy,
  filter_type = "range",
  filter_table = "samples",
  filter_variable = "DR",
  filter_value = c(0, 0.2)
)

filter_tomic(
  brauer_2008_triple,
  filter_type = "quo",
  filter_table = "features",
  filter_value = rlang::quo(BP == "biological process unknown")
)
}
