% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_gguniv.R
\name{plot_univariate}
\alias{plot_univariate}
\title{Univariate Plot}
\usage{
plot_univariate(tomic_table, x_var, color_var = NULL)
}
\arguments{
\item{tomic_table}{A table taken from a tidy (i.e., augmented measurements)
or triple omic dataset}

\item{x_var}{x-axis variable}

\item{color_var}{coloring variable (NULL to suppress coloring)}
}
\value{
A ggplot2 grob
}
\description{
Create a histogram from a tomic dataset.
}
\examples{
library(dplyr)

brauer_augmented <- brauer_2008_tidy \%>\%
  add_pca_loadings(npcs = 5) \%>\%
  tomic_to("triple_omic")

plot_univariate(brauer_augmented$samples, "PC1", "nutrient")
plot_univariate(brauer_augmented$measurements, "expression", NULL)
}
