% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_config.R
\name{load_config}
\alias{load_config}
\title{Load configuration}
\usage{
load_config(filename, config, ..., as_is = FALSE, default = "default")
}
\arguments{
\item{filename}{Configuration file to read from.}

\item{config}{Name of entry in configuration file to layer on top of 'default'.

Not used if \code{as_is = TRUE}.}

\item{...}{Not currently used.}

\item{as_is}{Should the configuration file be read in as is, without layering on top of
the \code{default} config?

Defaults to \code{FALSE}.}

\item{default}{The default configuration to use.}
}
\value{
If \code{as_is = FALSE} (default) a list contain entries corresponding to the
chosen \code{config}. If \code{as_is = TRUE}, a list of all entries in the evaluated
configuration file.
}
\description{
Load a user defined configuration from file. By default
(i.e. when \code{as_is = FALSE}), \code{load_config()} requires inputs to be given as
uniquely-named lists. It first parses the configuration file looking for a
'default' entry. With no additional arguments this will be returned as a list
to the user. If the user specifies an additional list to consider (via the
\code{config} argument) then this list is layered on top
(using \code{utils::modifyList()}).
}
\details{
Configuration files can be specified using a reduced subset of base R.
Currently this is restricted to the following operators and functions:
\itemize{
\item <-, =, +, -, *, :,
\item as.Date (for character inputs),
\item array, matrix,
\item list, data.frame,
\item c,
\item length,
\item seq (for numeric and date inputs),
\item sequence (for numeric inputs),
\item seq_len, seq_along,
\item Sys.Date and Sys.time.
}

We also enable a convenience function, \code{cc}, which automatically quotes input
to save typing.
}
\examples{
# load the example configuration
file <- system.file("config.R", package = "ronfig")
cat(readChar(file, file.info(file)$size))

# default configuration
str(load_config(file))

# debug configuration
str(load_config(file, "debug"))

# forecast configuration
str(load_config(file, "forecast"))

}
