% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_glm_format.R
\name{write_glm_format}
\alias{write_glm_format}
\title{Write ensemble forecast dataframe to General Lake Model formatted csv files}
\usage{
write_glm_format(df, path)
}
\arguments{
\item{df}{data frame output by \code{get_ensemble_forecast()}}

\item{path}{directory where csv files will be written}
}
\value{
No return value, called to generate csv files in the GLM required format
}
\description{
Write ensemble forecast dataframe to General Lake Model formatted csv files
}
\examples{

\dontshow{
# Hide setting tempfile, since a user would specify a persistent location
 path <- tempdir()
}

file <- system.file("extdata", "test-data.csv", package="ropenmeteo")
df <- readr::read_csv(file, show_col_types = FALSE)
df |>
   add_longwave() |>
   write_glm_format(path = path)
\dontshow{
# tidy
 unlink(path)
}
}
