% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{example4_wild_fun}
\alias{example4_wild_fun}
\title{Example 4: Minimize a "wild" function using SANN and BFGS}
\usage{
example4_wild_fun()
}
\description{
Minimize a "wild" function using SANN and BFGS.
}
\examples{
## "wild" function , global minimum at about -15.81515
fw <- function (x)
 10*sin(0.3*x)*sin(1.3*x^2) + 0.00001*x^4 + 0.2*x+80
plot(fw, -50, 50, n = 1000, main = "optim() minimising 'wild function'")

res <- optim(50, fw, method = "SANN",
            control = list(maxit = 20000, temp = 20, parscale = 20))
res
## Now improve locally {typically only by a small bit}:
(r2 <- optim(res$par, fw, method = "BFGS"))
points(r2$par,  r2$value,  pch = 8, col = "red", cex = 2)

## corresponding C++ implementation:
example4_wild_fun()
}
