% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RosvQueryBatch.R
\name{RosvQueryBatch}
\alias{RosvQueryBatch}
\title{R6 Class for OSV Querybatch Endpoint}
\value{
An R6 object to operate with OSV querybatch endpoint.
}
\description{
An R6 class to provide a lower-level interface to the querybatch
endpoint of the OSV API. Batches are enforced to only process by commit hash, purl, or name+ecosystem.
This avoids some confusion as to which is taken preferentially and simplifies query creation.
}
\details{
Pageination is implemented via \code{httr2::req_perform_iterative()} and a private method for
extracting tokens automatically. When initialized, the page_token is set to \code{NULL};
if a token is generated for large results the process is handled internally. The response object
will contain a list of all returned responses before any formatting occurred. The content field will
contain the list of results with vulnerabilities which may be further parsed into a table format.
}
\examples{
pkgs <- c('jinja2', 'dask')
ecosystem <- rep('PyPI', length(pkgs))
batchquery <- RosvQueryBatch$new(name = pkgs, ecosystem = ecosystem)
batchquery

}
\seealso{
\url{https://google.github.io/osv.dev/post-v1-querybatch/}
}
\section{Super class}{
\code{\link[rosv:RosvQuery1]{rosv::RosvQuery1}} -> \code{RosvQueryBatch}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RosvQueryBatch-new}{\code{RosvQueryBatch$new()}}
\item \href{#method-RosvQueryBatch-run}{\code{RosvQueryBatch$run()}}
\item \href{#method-RosvQueryBatch-parse}{\code{RosvQueryBatch$parse()}}
\item \href{#method-RosvQueryBatch-clone}{\code{RosvQueryBatch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rosv" data-topic="RosvQuery1" data-id="print"><a href='../../rosv/html/RosvQuery1.html#method-RosvQuery1-print'><code>rosv::RosvQuery1$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQueryBatch-new"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQueryBatch-new}{}}}
\subsection{Method \code{new()}}{
Set the core request details for subsequent use when called in \code{run()} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQueryBatch$new(
  commit = NULL,
  version = NULL,
  name = NULL,
  ecosystem = NULL,
  purl = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{commit}}{Commit hash to query against (do not use when version set).}

\item{\code{version}}{Version of package.}

\item{\code{name}}{Name of package.}

\item{\code{ecosystem}}{Ecosystem package lives within (must be set if using \code{name}).}

\item{\code{purl}}{URL for package (do not use if \code{name} or \code{ecosystem} is set).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQueryBatch-run"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQueryBatch-run}{}}}
\subsection{Method \code{run()}}{
Perform the request and return response for OSV API call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQueryBatch$run()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQueryBatch-parse"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQueryBatch-parse}{}}}
\subsection{Method \code{parse()}}{
Parse the contents returned into a tidier format.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQueryBatch$parse()}\if{html}{\out{</div>}}
}

\subsection{Details}{
When no result is found, any empty list is returned by the API, which
during parsing will be dropped as the list is flattened. However, the
index of the list is still accessible and the dropped items can easily
be identified from the results column. Not all contents are parsed.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvQueryBatch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RosvQueryBatch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvQueryBatch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
