% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lists.R
\name{create_osv_list}
\alias{create_osv_list}
\title{List packages identified in the OSV database}
\usage{
create_osv_list(
  rosv_query = NULL,
  as.data.frame = TRUE,
  sort = TRUE,
  delim = "\\t",
  NA_value = NULL
)
}
\arguments{
\item{rosv_query}{A table of vulnerabilities (created via \code{osv_query()}).}

\item{as.data.frame}{Boolean value to determine if a data.frame should be returned.}

\item{sort}{Boolean value to determine if results should be sorted by name and version.}

\item{delim}{The deliminator to separate the package and version details (ignored if \code{as.data.frame} set to \code{TRUE}).}

\item{NA_value}{Character value to replace missing versions (typically means all versions impacted).}
}
\value{
A \code{data.frame()} or vector object containing the package and version details.
}
\description{
Create a list of package names and versions based upon vulnerabilities discovered in the OSV database
using \code{\link{osv_query}}.
}
\details{
Requires an object of type \code{rosv_query} created by \code{\link{osv_query}}. This can be
a selection of packages or all vulnerabilities for an ecosystem. Depending on use-case, users may
prefer the vector based output with pairs of package names and versions separated by a provided value.
Since only name and versions are returned, only one ecosystem can be operated on at a time.

Please note, the default behaviour of \code{osv_query()} is to return all packages (and versions) across ecosystems
associated with discovered vulnerabilities. If a package is discovered across several vulnerabilities it will
be listed multiple times, by default, in the returned content. Unlike \code{osv_query()}, \code{create_osv_list()} will
further sort and return a unique set of packages. In most circumstances, users will create the
\code{rosv_query} (via \code{osv_query()}) with the \code{all_affected} parameter set to \code{FALSE}
so that only the package names of interest are returned.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# List of a few PyPI packages in data.frame output
pypi_query <- osv_query(c('dask', 'dash', 'aaiohttp'),
                        ecosystem = rep('PyPI', 3),
                        all_affected = FALSE)
pypi_vul <- create_osv_list(pypi_query)
file_name1 <- file.path(tempdir(), 'pypi_vul.csv')
writeLines(pypi_vul, file_name1)

# All CRAN vulns in vector output
cran_query <- osv_query(ecosystem = 'CRAN', all_affected = FALSE)
cran_vul <- create_osv_list(cran_query, as.data.frame = FALSE, delim = ',')
file_name2 <- file.path(tempdir(), 'cran_vul.csv')
writeLines(cran_vul, file_name2)

# Clean up
try(unlink(c(file_name1, file_name2)))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{osv_query}}
}
