\name{pointsXYZ}
\alias{pointsXYZ}
\title{Project rotation data onto sphere}
\usage{
  pointsXYZ(data, center = id.SO3, column = 1)
}
\arguments{
  \item{data}{data frame of rotation matrices in
  \eqn{3\times 3}{3-by-3} matrix representation.}

  \item{center}{rotation matrix about which to center the
  observations.}

  \item{column}{integer 1 to 3 indicating which column to
  display.}
}
\value{
  Data frame with columns X, Y, Z standing for the
  respective coordinates in 3D space.
}
\description{
  Projection of rotation matrices onto sphere with given
  center.
}
\examples{
Rs<-ruars(20, rcayley)

#Project the sample's 3 axes onto the 3-shere centered at the identity rotation

pointsXYZ(Rs, center = id.SO3, column = 1)  #x-axis
pointsXYZ(Rs, center = id.SO3, column = 2)  #y-axis
pointsXYZ(Rs, center = id.SO3, column = 3)  #z-axis
}

