% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_route.R
\name{report_route}
\alias{report_route}
\title{Create a route that renders and serves an Rmarkdown or Quarto report}
\usage{
report_route(
  path,
  file,
  ...,
  max_age = Inf,
  async = TRUE,
  finalize = NULL,
  continue = FALSE,
  ignore_trailing_slash = FALSE
)
}
\arguments{
\item{path}{The url path to serve the report from}

\item{file}{The quarto or rmarkdown file to use for rendering of the report}

\item{...}{Further arguments to \code{quarto::quarto_render()} or
\code{rmarkdown::render()}}

\item{max_age}{The maximum age in seconds to keep a rendered report before
initiating a re-render}

\item{async}{Should rendering happen asynchronously (using mirai)}

\item{finalize}{An optional function to run before sending the response back.
The function will receive the request as the first argument, the response as
the second, and anything passed on through \code{...} in the \code{dispatch} method.
Any return value from the function is discarded. The function must accept
\code{...}}

\item{continue}{A logical that defines whether the response is returned
directly after rendering or should be made available to subsequent routes}

\item{ignore_trailing_slash}{Should \code{path} be taken exactly or should both a
version with and without a terminating slash be accepted}
}
\value{
A \link{route} object
}
\description{
This route allows you to serve a report written as a Quarto/Rmarkdown
document. The report will be rendered on demand using the query params as
parameters for the report if they match. Depending on the value of the value
of \code{max_age} the rendered report is kept and served without a re-render on
subsequent requests. The rendering can happen asynchronously in which case
a promise is returned.
}
\details{
Only the formats explicitely stated in the header of the report are allowed
and the will be selected through content negotiation. That means that if
multiple formats produces the same file type, only the first will be
available. If no format is specified the default for both Quarto and
Rmarkdown documents is HTML
}
