% Generated by roxygen2 (4.0.0): do not edit by hand
\name{vectorize}
\alias{vectorize}
\title{Vectorize a scalar function to work on any R object.}
\usage{
vectorize(fun, type = NULL)
}
\arguments{
\item{fun}{a two or more argument function}

\item{type}{like \code{MARGIN} in \code{\link{apply}}, except that \code{c(1,2)} is
represented as a \code{3} instead.  By default, will \code{Reduce} single dimensional
data handle everything else row-wise.}
}
\description{
Robust alternative to \code{\link{Vectorize}} function that accepts any function with two
or more arguments.  Returns a function that will work an arbitrary number of vectors, lists or
data frames, though output may be unpredicatable in unusual applications.  The
results are also intended to be more intuitive than Vectorize.
}
\examples{
vectorize(`+`)(c(1,2,3))
vectorize(sum)(c(1,2,3),c(1,2,3))
# Compare these results to Vectorize, which does not vectorize sum at all.
Vectorize(sum)(c(1,2,3),c(1,2,3))
# Across data frame columns.
df<-data.frame(a=c(1,2,3),b=c(1,2,3))
vectorize(sum)(df$a,df$b)
# Once again, Vectorize gives a different result
Vectorize(sum)(df$a,df$b)
# Any combination of vectors, lists, matrices, or data frames an be used.
vectorize(`+`)(c(1,2,3),list(1,2,3),cbind(c(1,2,3)))
}

