% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getSampleSizeRates}
\alias{getSampleSizeRates}
\title{Get Sample Size Rates}
\usage{
getSampleSizeRates(design, ..., normalApproximation = TRUE,
  riskRatio = FALSE, thetaH0 = 0, pi1 = seq(0.4, 0.6, 0.1), pi2 = 0.2,
  groups = 2, allocationRatioPlanned = 1)
}
\arguments{
\item{design}{The trial design.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{normalApproximation}{If \code{normalApproximation = FALSE} is specified, the sample size 
for the case of one treatment group is calculated exactly using the binomial distribution. 
default is TRUE.}

\item{riskRatio}{If \code{riskRatio = TRUE} is specified, the sample size for one-sided 
testing of H0: pi1/pi2 = thetaH0 is calculated, default is FALSE.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or != 1 for testing the risk ratio pi1/pi2) can be specified, default is 0.}

\item{pi1}{The assumed probability in the treatment group if two treatment groups 
are considered, or the alternative probability for a one treatment group design, 
default is seq(0.4, 0.6, 0.1).}

\item{pi2}{The assumed probability in the control group if two treatment groups are considered, default is 0.2.}

\item{groups}{The number of treatment groups (1 or 2), default is 2.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups design. \cr
If \code{allocationRatioPlanned = 0} is entered, the optimal allocation ratio yielding the 
smallest overall sample size is determined, default is 1.}
}
\value{
Returns a \code{TrialDesignPlanRates} object.
}
\description{
Returns the sample size for testing rates in one and two samples.
}
\details{
At given design the function calculates the sample size for testing rates.
In a two treatment groups design, additionally, an allocation ratio = n1Fixed/n2Fixed can be specified. 
If a null hypothesis value thetaH0 != 0 for testing the difference of two rates 
thetaH0 != 1 for testing the risk ratio is specified, the sample size 
formula according to Farrington & Manning (Statistics in Medicine, 1990) is used.
}
\examples{

# Calculate sample sizes n1Fixed, n2Fixed, nFixed, and the optimum 
# allocation ratios for a range of pi1 values when testing 
# H0: pi1 - pi2 = -0.1:
getSampleSizeRates(getDesignGroupSequential(alpha = 0.025, beta = 0.2, 
    sided = 1), groups = 2, thetaH0 = -0.1, pi1 = seq(0.4, 0.55, 0.025), 
    pi2 = 0.4, normalApproximation = TRUE, allocationRatioPlanned = 0)

# Calculate sample sizes n1Fixed, n2Fixed, nFixed, and the optimum 
# allocation ratios for a range of pi2 values when testing 
# H0: pi1 / pi2 = 1.25:
getSampleSizeRates(getDesignGroupSequential(alpha = 0.025, beta = 0.2, 
    sided = 1), groups = 2, riskRatio = TRUE, thetaH0 = 1.25, pi1 = 0.3, 
    pi2 = 0.3, normalApproximation = TRUE, allocationRatioPlanned = 1)

}
