% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_means.R
\name{getSimulationMeans}
\alias{getSimulationMeans}
\title{Get Simulation Means}
\usage{
getSimulationMeans(design = NULL, ..., groups = 2L,
  meanRatio = FALSE, thetaH0 = ifelse(meanRatio, 1, 0),
  alternative = C_ALTERNATIVE_POWER_SIMULATION_DEFAULT,
  stDev = C_STDEV_DEFAULT, plannedSubjects = NA_real_,
  directionUpper = C_DIRECTION_UPPER_DEFAULT,
  allocationRatioPlanned = NA_real_,
  minNumberOfSubjectsPerStage = NA_real_,
  maxNumberOfSubjectsPerStage = NA_real_, conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  maxNumberOfIterations = C_MAX_SIMULATION_ITERATIONS_DEFAULT,
  seed = NA_real_, calcSubjectsFunction = NULL)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, \code{alpha}, \code{beta}, and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{meanRatio}{If \code{meanRatio = TRUE} is specified, the design characteristics for 
one-sided testing of H0: mu1/mu2 = thetaH0 are simulated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or a value != 1 for testing the mean ratio) can be specified, default is 
\code{0} or \code{1} for difference and ratio testing, respectively.}

\item{alternative}{The alternative hypothesis value. This can be a vector of assumed 
alternatives, default is \code{seq(0,1,0.2)}.}

\item{stDev}{The standard deviation under which the conditional power calculation is performed, default is 1. 
If \code{meanRatio = TRUE} is specified, stDev defines the coefficient of variation sigma/mu2.}

\item{plannedSubjects}{\code{plannedSubjects} is a vector of length \code{kMax} (the number of stages of the design) 
that determines the number of cumulated (overall) subjects when the interim stages are planned.}

\item{directionUpper}{Specifies the direction of the alternative, only applicable 
for one-sided testing, default is \code{TRUE}.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups 
design, default is \code{1}.}

\item{minNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{minNumberOfSubjectsPerStage} determines the 
minimum number of subjects per stage (i.e., not cumulated), the first element 
is not taken into account.}

\item{maxNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
   the vector with length kMax \code{maxNumberOfSubjectsPerStage} determines the maximum number 
of subjects per stage (i.e., not cumulated), the first element is not taken into account.}

\item{conditionalPower}{The conditional power for the subsequent stage under which the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the alternative under which the conditional power calculation is performed.}

\item{maxNumberOfIterations}{The number of simulation iterations.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcSubjectsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalulation is performed with conditional power with specified
\code{minNumberOfSubjectsPerStage} and \code{maxNumberOfSubjectsPerStage} (see details
and examples).}
}
\value{
Returns a  \code{\link{SimulationResultsMeans}} object.
}
\description{
Returns the simulated power, stopping probabilities, conditional power, and expected sample size 
for testing means in a one or two treatment groups testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, conditional power, and expected 
sample size at given number of subjects and parameter configuration. 
Additionally, an allocation ratio = n1/n2 can be specified where n1 and n2 are the number 
of subjects in the two treatment groups.

calcSubjectsFunction\cr 
This function returns the number of subjects at given conditional power and conditional Type I error rate for specified 
testing situation. The function might depend on variables \code{stage}, \code{meanRatio}, \code{thetaH0}, \code{groups}, 
\code{plannedSubjects}, \code{sampleSizesPerStage}, \code{directionUpper}, \code{allocationRatioPlanned}, 
\code{minNumberOfSubjectsPerStage}, 
\code{maxNumberOfSubjectsPerStage}, \code{conditionalPower}, \code{conditionalCriticalValue}, 
\code{thetaStandardized}.
The function has to obtain the three-dots arument '...' (see examples).
}
\section{Simulation Data}{

The summary statistics "Simulated data" contains the following parameters: median [range]; mean +/-sd\cr

\code{$show(showStatistics = FALSE)} or \code{$setShowStatistics(FALSE)} can be used to disable 
the output of the aggregated simulated data.\cr

Example 1: \cr
\code{simulationResults <- getSimulationMeans(plannedSubjects = 40)} \cr
\code{simulationResults$show(showStatistics = FALSE)}\cr

Example 2: \cr
\code{simulationResults <- getSimulationMeans(plannedSubjects = 40)} \cr
\code{simulationResults$setShowStatistics(FALSE)}\cr
\code{simulationResults}\cr

\code{\link{getData}} can be used to get the aggregated simulated data from the 
object as \code{\link[base]{data.frame}}. The data frame contains the following columns:
\enumerate{
  \item \code{iterationNumber}: The number of the simulation iteration.
  \item \code{stageNumber}: The stage.
  \item \code{alternative}: The alternative hypothesis value.
  \item \code{numberOfSubjects}: The number of subjects under consideration when the 
        (interim) analysis takes place.
  \item \code{rejectPerStage}: 1 if null hypothesis can be rejected, 0 otherwise. 
  \item \code{futilityPerStage}: 1 if study should be stopped for futility, 0 otherwise.
  \item \code{testStatistic}: The test statistic that is used for the test decision, 
        depends on which design was chosen (group sequential, inverse normal, or Fishers combination test).  
  \item \code{testStatisticsPerStage}: The test statistic for each stage if only data from
			the considered stage is taken into account.
  \item \code{effectEstimate}: Standardized overall simulated effect estimate. 
  \item \code{trialStop}: \code{TRUE} if study should be stopped for efficacy or futility or final stage, \code{FALSE} otherwise.  
  \item \code{conditionalPowerAchieved}: The conditional power for the subsequent stage of the trial for 
			selected sample size and effect. The effect is either estimated from the data or can be
			user defined with \code{thetaH1}.   
}
}

\examples{

# Fixed sample size with minimum required definitions, 
# alternative = c(0, 1, 2, 3, 4), standard deviation = 5  
getSimulationMeans(getDesignGroupSequential(), alternative = 40, 
    stDev = 50, plannedSubjects = c(20, 40, 60), thetaH1 = 60, 
    maxNumberOfIterations = 50)

\donttest{

# Increase number of simulation iterations and compare results 
# with power calculator using normal approximation 
getSimulationMeans(alternative = 0:4, stDev = 5, 
    plannedSubjects = 40, maxNumberOfIterations = 50)
getPowerMeans(alternative = 0:4, stDev = 5, 
    maxNumberOfSubjects = 40, normalApproximation = TRUE)

# Do the same for a three-stage O'Brien&Fleming inverse 
# normal group sequential design with non-binding futility stops
designIN <- getDesignInverseNormal(typeOfDesign = "OF", futilityBounds = c(0, 0))
x <- getSimulationMeans(designIN, alternative = c(0:4), stDev = 5, 
    plannedSubjects = c(20, 40, 60), maxNumberOfIterations = 1000)
getPowerMeans(designIN, alternative = 0:4, stDev = 5, 
    maxNumberOfSubjects = 60, normalApproximation = TRUE)

# Assess power and average sample size if a sample size increase is foreseen 
# at conditional power 80\% for each subsequent stage based on observed overall 
# effect and specified minNumberOfSubjectsPerStage and
# maxNumberOfSubjectsPerStage
getSimulationMeans(designIN, alternative = 0:4, stDev = 5, 
    plannedSubjects = c(20, 40, 60), 
    minNumberOfSubjectsPerStage = c(20, 20, 20), 
    maxNumberOfSubjectsPerStage = c(80, 80, 80),
    conditionalPower = 0.8,	
	   maxNumberOfIterations = 50)

# Do the same under the assumption that a sample size increase only takes 
# place at the first interim. The sample size for the third stage is set equal 
# to the second stage sample size.
mySampleSizeCalculationFunction <- function(..., stage, 
        minNumberOfSubjectsPerStage,
        maxNumberOfSubjectsPerStage,
        sampleSizesPerStage,
        conditionalPower,
        conditionalCriticalValue,
        thetaStandardized) {
    if (stage == 2) {
        stageSubjects <- 4 * (max(0, conditionalCriticalValue + 
            stats::qnorm(conditionalPower)))^2 / (max(1e-12, thetaStandardized))^2
        stageSubjects <- min(max(minNumberOfSubjectsPerStage[stage], 
            stageSubjects), maxNumberOfSubjectsPerStage[stage])
    } else {
        stageSubjects <- sampleSizesPerStage[stage - 1]
    }
    return(stageSubjects)
}
getSimulationMeans(designIN, alternative = 2:4, stDev = 5, 
    plannedSubjects = c(20, 40, 60), 
    minNumberOfSubjectsPerStage = c(20, 20, 20), 
    maxNumberOfSubjectsPerStage = c(40, 160, 160),
    conditionalPower = 0.8, 
    calcSubjectsFunction = mySampleSizeCalculationFunction, 
    maxNumberOfIterations = 50)

}

}
