% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getPowerSurvival}
\alias{getPowerSurvival}
\title{Get Power Survival}
\usage{
getPowerSurvival(
  design = NULL,
  ...,
  typeOfComputation = c("Schoenfeld", "Freedman", "HsiehFreedman"),
  thetaH0 = C_THETA_H0_SURVIVAL_DEFAULT,
  directionUpper = NA,
  pi1 = NA_real_,
  pi2 = NA_real_,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  median1 = NA_real_,
  median2 = NA_real_,
  kappa = 1,
  hazardRatio = NA_real_,
  piecewiseSurvivalTime = NA_real_,
  allocationRatioPlanned = 1,
  eventTime = C_EVENT_TIME_DEFAULT,
  accrualTime = C_ACCRUAL_TIME_DEFAULT,
  accrualIntensity = C_ACCRUAL_INTENSITY_DEFAULT,
  maxNumberOfSubjects = NA_real_,
  maxNumberOfEvents = NA_real_,
  dropoutRate1 = C_DROP_OUT_RATE_1_DEFAULT,
  dropoutRate2 = C_DROP_OUT_RATE_2_DEFAULT,
  dropoutTime = C_DROP_OUT_TIME_DEFAULT
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, \code{alpha}, \code{beta}, and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{typeOfComputation}{Three options are available: "Schoenfeld", "Freedman", "HsiehFreedman", 
the default is "Schoenfeld". For details, see Hsieh 
(Statistics in Medicine, 1992). For non-inferiority testing (i.e., thetaH0 != 1),
   only Schoenfelds formula can be used}

\item{thetaH0}{The null hypothesis value. The default value is 1. For one-sided testing, 
a bound for testing H0: hazard ratio = thetaH0 != 1 can be specified.}

\item{directionUpper}{Specifies the direction of the alternative, only applicable for one-sided testing, default is TRUE.}

\item{pi1}{The assumed event rate in the treatment group, default is \code{seq(0.2,0.5,0.1)}.}

\item{pi2}{The assumed event rate in the control group, default is 0.2.}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
lambda1 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
lambda2 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{median1}{The assumed median survival time in the treatment group, there is no default.}

\item{median2}{The assumed median survival time in the reference group, there is no default.}

\item{kappa}{The shape parameter of the Weibull distribution, default is \code{1}. 
The Weibull distribution cannot be used for the piecewise definition of the survival time distribution. 
Note that the parameters \code{shape} and \code{scale} in \code{\link[stats]{Weibull}} 
are equivalent to \code{kappa} and \code{1 / lambda}, respectively, in rpact.}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function (see details).}

\item{allocationRatioPlanned}{The planned allocation ratio, default is \code{1}.}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{accrualTime}{The assumed accrual time intervals for the study, default is \code{c(0,12)}  (see details).}

\item{accrualIntensity}{A vector of accrual intensities, default is \code{1} (see details).}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified.
If accrual time and accrual intensity is specified, this will be calculated.}

\item{maxNumberOfEvents}{\code{maxNumberOfEvents > 0} is the maximum number of events, determines 
the power of the test and needs to be specified.}

\item{dropoutRate1}{The assumed drop-out rate in the treatment group, default is \code{0}.}

\item{dropoutRate2}{The assumed drop-out rate in the control group, default is \code{0}.}

\item{dropoutTime}{The assumed time for drop-out rates in the control and the 
treatment group, default is \code{12}.}
}
\value{
Returns a \code{\link{TrialDesignPlanSurvival}} object.
}
\description{
Returns the power, stopping probabilities, and expected sample size for testing the hazard ratio in a two treatment groups survival design.
}
\details{
At given design the function calculates the power, stopping probabilities, and expected 
sample size at given number of events and number of subjects. 
It also calculates the time when the required events are expected under the given 
assumptions (exponentially, piecewise exponentially, or Weibull distributed survival times 
and constant or non-constant piecewise accrual). 
Additionally, an allocation ratio = n1/n2 can be specified where n1 and n2 are the number 
of subjects in the two treatment groups. 
 
The formula of Kim & Tsiatis (Biometrics, 1990) 
is used to calculated the expected number of events under the alternative 
(see also Lakatos & Lan, Statistics in Medicine, 1992). These formulas are generalized to piecewise survival times and 
non-constant piecewise accrual over time.\cr

\code{piecewiseSurvivalTime} 
The first element of this vector must be equal to \code{0}. \code{piecewiseSurvivalTime} can also 
be a list that combines the definition of the time intervals and hazard rates in the reference group. 
The definition of the survival time in the treatment group is obtained by the specification 
of the hazard ratio (see examples for details).

\code{accrualTime} can also be used to define a non-constant accrual over time. 
For this, \code{accrualTime} needs to be a vector that defines the accrual intervals and
\code{accrualIntensity} needs to be specified. The first element of \code{accrualTime} must be equal to 0.\cr 
\code{accrualTime} can also be a list that combines the definition of the accrual time and 
accrual intensity \code{accrualIntensity} (see below and examples for details). 
If the length of \code{accrualTime} and the length of \code{accrualIntensity} are 
the same (i.e., the end of accrual is undefined), \code{maxNumberOfSubjects > 0} needs to 
be specified and the end of accrual is calculated.	

\code{accrualIntensity} needs to be defined if a vector of \code{accrualTime} is specified.\cr
If the length of \code{accrualTime} and the length of \code{accrualIntensity} are the same 
(i.e., the end of accrual is undefined), \code{maxNumberOfSubjects > 0} needs to be specified 
and the end of accrual is calculated.	
In that case, \code{accrualIntensity} is given by the number of subjects per time unit.\cr
If the length of \code{accrualTime} equals the length of \code{accrualIntensity - 1}   
(i.e., the end of accrual is defined), \code{maxNumberOfSubjects} is calculated.\cr 
If all elements in \code{accrualIntensity} are smaller than 1, \code{accrualIntensity} defines 
the *relative* intensity how subjects enter the trial.
For example, \code{accrualIntensity = c(0.1, 0.2)} specifies that in the second accrual interval 
the intensity is doubled as compared to the first accrual interval. The actual accrual intensity 
is calculated for the given \code{maxNumberOfSubjects}.
Note that the default is \code{accrualIntensity = 0.1} meaning that the *absolute* accrual intensity 
will be calculated.
}
\examples{

# Fixed sample size with minimum required definitions, pi1 = c(0.4,0.5,0.5) and 
# pi2 = 0.2 at event time 12, accrual time 12 and follow-up time 6 as default 
getPowerSurvival(maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

\donttest{

# Four stage O'Brien & Fleming group sequential design with minimum required 
# definitions, pi1 = c(0.4,0.5,0.5) and pi2 = 0.2 at event time 12, 
# accrual time 12 and follow-up time 6 as default  
getPowerSurvival(design = getDesignGroupSequential(kMax = 4), 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# For fixed sample design, determine necessary accrual time if 200 subjects and 
# 30 subjects per time unit can be recruited 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0), 
    accrualIntensity = 30, maxNumberOfSubjects = 200)

# Determine necessary accrual time if 200 subjects and if the first 6 time units 
# 20 subjects per time unit can be recruited, then 30 subjects per time unit 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0, 6), 
    accrualIntensity = c(20, 30), maxNumberOfSubjects = 200)

# Determine maximum number of Subjects if the first 6 time units 20 subjects per 
# time unit can be recruited, and after 10 time units 30 subjects per time unit
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = c(0, 6, 10), accrualIntensity = c(20, 30))

# Specify accrual time as a list
at <- list(
    "0 - <6"  = 20,
    "6 - Inf" = 30)
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = at, maxNumberOfSubjects = 200)

# Specify accrual time as a list, if maximum number of subjects need to be calculated
at <- list(
    "0 - <6"   = 20,
    "6 - <=10" = 30) 
getPowerSurvival(maxNumberOfEvents = 40, accrualTime = at)

# Specify effect size for a two-stage group design with O'Brien & Fleming boundaries
# Effect size is based on event rates at specified event time, directionUpper = FALSE 
# needs to be specified because it should be shown that hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), pi1 = 0.2, pi2 = 0.3, 
    eventTime = 24, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)

# Effect size is based on event rate at specified event time for the reference group 
# and hazard ratio, directionUpper = FALSE needs to be specified 
# because it should be shown that hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), hazardRatio = 0.5, pi2 = 0.3, 
    eventTime = 24, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)

# Effect size is based on hazard rate for the reference group and hazard ratio, 
# directionUpper = FALSE needs to be specified because it should be shown that hazard ratio < 1
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), hazardRatio = 0.5, 
    lambda2 = 0.02, maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE) 

# Specification of piecewise exponential survival time and hazard ratios  
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
    piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01,0.02,0.04), 
    hazardRatio = c(1.5, 1.8, 2),  maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time as list and hazard ratios 
pws <- list(
    "0 - <5"  = 0.01,	
	   "5 - <10" = 0.02,	
	   ">=10"    = 0.04)
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = pws, hazardRatio = c(1.5, 1.8, 2), 
	   maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time for both treatment arms  
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = c(0, 5, 10), lambda2 = c(0.01, 0.02, 0.04), 
	   lambda1 = c(0.015,0.03,0.06),  maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specification of piecewise exponential survival time as a list
pws <- list(
    "0 - <5"  = 0.01,
	   "5 - <10" = 0.02,
	   ">=10"    = 0.04)
getPowerSurvival(design = getDesignGroupSequential(kMax = 2), 
	   piecewiseSurvivalTime = pws, hazardRatio = c(1.5, 1.8, 2), 
	   maxNumberOfEvents = 40, maxNumberOfSubjects = 200)

# Specify effect size based on median survival times
getPowerSurvival(median1 = 5, median2 = 3, 
	   maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)

# Specify effect size based on median survival times of Weibull distribtion with kappa = 2
getPowerSurvival(median1 = 5, median2 = 3, kappa = 2, 
	   maxNumberOfEvents = 40, maxNumberOfSubjects = 200, directionUpper = FALSE)

}

}
