% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{as.track.msa}
\alias{as.track.msa}
\title{Create an alignment track}
\usage{
as.track.msa(x, name, refseq = names.msa(x)[1], short.label = NULL,
  pretty = TRUE, nuc.text = NULL, nuc.text.pos = "bottom",
  nuc.text.col = "black")
}
\arguments{
\item{x}{An object of type \code{msa}}

\item{name}{The name of the track (a character string)}

\item{refseq}{A character string identifying the sequence whose
coordinate range to use in the plot.  A value of \code{NULL} implies
the frame of reference of the entire alignment.}

\item{short.label}{An optional character string to be displayed in the
left-hand margin of the track}

\item{pretty}{If \code{TRUE}, display bases in the non-reference species
which are identical to the reference species as a dot.}

\item{nuc.text}{If not NULL, can be a vector of character strings.  Each
character string should be the same length as the MSA with respect to refseq.}

\item{nuc.text.pos}{If nuc.text is not NULL, can be either "top" or "bottom"
to indicate where to place nuc.text relative to the alignment.  Will be recycled
to the length of nuc.text.}

\item{nuc.text.col}{If nuc.text is not NULL, color to be used for printing nuc.text.
Will be recycled to the length of nuc.text.}
}
\value{
An object of type \code{track} which can be plotted with the
plot.track function
}
\description{
Create an alignment track
}
\note{
alignment plots will only be displayed if the plot is zoomed in
enough to show the alignment data.
}
\author{
Melissa J. Hubisz
}
\seealso{
plot.track
}
\keyword{plot}

