exampleArchive <- system.file("extdata", "examples.zip", package="rphast")
files <- c("ENr334-100k.fa", "gencode.ENr334-100k.gff", "rev.mod")
unzip(exampleArchive, files)
tm <- read.tm("rev.mod")
tm$tree <- name.ancestors(tm$tree)
msa <- read.msa("ENr334-100k.fa", offset=41405894)
phyloP(tm, msa, method="LRT", outfile="test.out", outfile.only=TRUE, outfile.format="wig")
t1 <- phyloP(tm, msa, method="LRT", outfile="test.out")
t2 <- phyloP(tm, msa, method="LRT", outfile="test.out", outfile.format="wig")
t1 <- phyloP(tm, msa, method="SPH")
f <- read.feat("gencode.ENr334-100k.gff")
t1 <- phyloP(tm, msa, method="LRT", outfile="test.out", features=f)
t2 <- phyloP(tm, msa, method="LRT", features=f,
             outfile="test.out", outfile.format="gff", outfile.only=TRUE)
unlink("test.out")
unlink(files)
