% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_phylopic.R
\name{phylopic_key_glyph}
\alias{phylopic_key_glyph}
\title{Use PhyloPics as legend key glyphs}
\usage{
phylopic_key_glyph(img = NULL, name = NULL, uuid = NULL)
}
\arguments{
\item{img}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{name}{\code{character}. A taxonomic name to be passed to \code{\link[=get_uuid]{get_uuid()}}.}

\item{uuid}{\code{character}. A valid uuid for a PhyloPic silhouette (such as
that returned by \code{\link[=get_uuid]{get_uuid()}} or \code{\link[=pick_phylopic]{pick_phylopic()}}).}
}
\description{
Specify existing images, taxonomic names, or PhyloPic uuids to use PhyloPic
silhouettes as legend key glyphs in a ggplot plot.
}
\details{
One (and only one) of \code{img}, \code{name}, or \code{uuid} must be specified.

This argument may also be a vector/list of valid values if multiple
silhouettes should be used as key glyphs. In this case, the specified
silhouettes will be used as ordered as key glyphs one by one, with
recycling as necessary.

Note that the sizes of the silhouettes in the legend are currently
maximized based on the size of the key. This size can be modified using the
\code{legend.key.size} argument in \code{\link[ggplot2:theme]{ggplot2::theme()}}. Therefore, the
silhouettes will not reflect the size aesthetic, and this function should
not be used for size legends.
}
\examples{
\dontrun{
library(ggplot2)
df <- data.frame(x = c(2, 4), y = c(10, 20),
                 name = c("Felis silvestris catus", "Odobenus rosmarus"))
ggplot(df) +
  geom_phylopic(aes(x = x, y = y, name = name, color = name), size = 10,
                show.legend = TRUE,
                key_glyph = phylopic_key_glyph(name =
                                               c("Felis silvestris catus",
                                                 "Odobenus rosmarus"))) +
  coord_cartesian(xlim = c(1,6), ylim = c(5, 30))
}
}
