% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/process_folder.R, R/process_input.R, R/process_solution.R
\name{process_folder}
\alias{process_folder}
\alias{process_input}
\alias{process_solution}
\title{Convert PLEXOS files to SQLite databases}
\usage{
process_folder(folders = ".", keep.temp = FALSE)

process_input(file)

process_solution(file, keep.temp = FALSE)
}
\arguments{
\item{folders}{Folder(s) to process (See details)}

\item{keep.temp}{Should temporary databases be preserved?}

\item{file}{Single PLEXOS solution or input file to process}
}
\description{
Functions to process PLEXOS solution and input files and dump them into SQLite databases
that are easier to read.
}
\details{
\code{process_solution} converts a single zipped PLEXOS solution into a SQLite database.
The resulting database file has a simplified structure so data can be retrieved easily.
The temporary database contains the original data structure in the PLEXOS solution file.

\code{process_input} converts a single PLEXOS input file (in XML form) solution into a
SQLite database. The database includes the raw tables and a series of views that better
organize the data.

\code{process_folders} is used to process one or more folders. It searches each folder for
PLEXOS solution or input files and applies \code{process_solution} or
\code{process_input} to each one of them.

The default folder is the working directory. If the wildcard \code{"*"} is provided, all
the folders in the working directory will be processed (the list of folders if provided by
the \code{\link{list_folders}} function).
}
\examples{
\dontrun{process_folder()}
\dontrun{process_folder("HiWind")}
\dontrun{process_solution("HiWind/Model WWSIS_c_RT_CoreB_M01_SC3 Solution.zip")}
\dontrun{process_input("WWSIS model.xml")}
}

