% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrate.R
\name{accrate.age}
\alias{accrate.age}
\title{Obtain estimated accumulation rates for any age of a core.}
\usage{
accrate.age(age, set = get("info"), cmyr = FALSE, BCAD = set$BCAD)
}
\arguments{
\item{age}{The age for which the accumulation rates need to be returned.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{cmyr}{Accumulation rates can be calculated in cm/year or year/cm. By default \code{cmyr=FALSE} and accumulation rates are calculated in year per cm.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}
}
\value{
all MCMC estimates of accumulation rate of the chosen age.
}
\description{
Obtain accumulation rates (in years per cm, so actually sedimentation times) as estimated by the MCMC iterations for any age of a core.
}
\details{
Considering accumulation rates is crucial for age-depth modelling, and even more so if they are subsequently
used for calculating proxy influx values, or interpreted as proxy for environmental change such as carbon accumulation. See also \code{accrate.age.ghost}, \code{accrate.depth} and \code{accrate.depth.ghost}.
Bacon deals explicitly with accumulation rate and its variability through defining prior distributions.
This function obtains accumulation rates (in years per cm, so actually sedimentation times) as estimated
by the MCMC iterations for any age of a core. Deals with only 1 age at a time. See also \code{accrate.depth}.
}
\examples{
  Plum(run=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
  accrate.a50 = accrate.age(50)
  plot(accrate.a50, pch='.')
  hist(accrate.a50)
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474.
 \url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
