% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_0_1_0.R
\name{rpms}
\alias{rpms}
\title{rpms}
\usage{
rpms(rp_equ, data, weights = ~1, strata = ~1, clusters = ~1, e_equ = ~1,
  e_fn = "survLm", l_fn = NULL, bin_size = NULL, perm_reps = 500L,
  pval = 0.05)
}
\arguments{
\item{rp_equ}{formula containing all variables for partitioning}

\item{data}{data.frame that includes variables used in rp_equ, e_equ, 
and design information}

\item{weights}{formula or vector of sample weights for each observation}

\item{strata}{formula or vector of strata labels}

\item{clusters}{formula or vector of cluster labels}

\item{e_equ}{formula for modeling data in each node}

\item{e_fn}{string name of function to use for modeling 
(only "survLm" is operational)}

\item{l_fn}{loss function (does nothing yet)}

\item{bin_size}{numeric minimum number of observations in each node}

\item{perm_reps}{integer specifying the number of permuations}

\item{pval}{numeric p-value used to reject null hypothesis in permutation 
test}
}
\value{
object of class "rpms"
}
\description{
main function producing a regression tree using variables
 from rp_equ to partition the data and fit the model e_equ on each node.
 Currently only uses data with complete cases.
}
\examples{
{
# model mean of retirement contributions with a binary tree while accounting 
# for clusterd data

rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data = CE,  clusters=~CID)
     
     
# model linear fit between retirement contributions and amount of income
# with a regression tree while accounting for clusterd data

rpms(FINDRETX~EDUC_REF+AGE_REF+BLS_URBN+REGION, data=CE,
     e_equ=FINDRETX~FINCBTAX, clusters=~CID)     

}
}
