% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_table_exports.R
\name{layout_to_blocks_data_table}
\alias{layout_to_blocks_data_table}
\title{Map a data records from row records to block records with one record row per columnsToTakeFrom value.}
\usage{
layout_to_blocks_data_table(data, ..., nameForNewKeyColumn,
  nameForNewValueColumn, columnsToTakeFrom,
  columnsToCopy = setdiff(colnames(data), columnsToTakeFrom))
}
\arguments{
\item{data}{data.frame to work with.}

\item{...}{force later arguments to bind by name.}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{columnsToCopy}{character array names of columns to copy.}
}
\value{
new data.frame with values moved to rows.
}
\description{
Map a data records from row records (records that are exactly single rows) to block records
(records that may be more than one row).  All columns not named in columnsToTakeFrom are copied to each
record row in the result.
}
\examples{

(d <- wrapr::build_frame(
  "id"  , "id2", "AUC", "R2" |
    1   , "a"  , 0.7  , 0.4  |
    2   , "b"  , 0.8  , 0.5  ))

(layout_to_blocks_data_table(
  d,
  nameForNewKeyColumn = "measure",
  nameForNewValueColumn = "value",
  columnsToTakeFrom = c("AUC", "R2"),
  columnsToCopy = c("id", "id2")))


}
\keyword{internal}
