% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_with_NULLs.R
\name{replace_null_cols}
\alias{replace_null_cols}
\title{Replace or COALESCE out NULLs per row for given column set.}
\usage{
replace_null_cols(source, cols, val)
}
\arguments{
\item{source}{incoming rel_op tree or data.frame.}

\item{cols}{character, columns to replace NULLs in.}

\item{val}{relpacement value.}
}
\value{
rel_op node or data.frame (depending on input).
}
\description{
Build a query that replaces NULL values in selected columns.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  winvector_temp_db_handle <- list(
    db = my_db
  )
  RSQLite::initExtension(winvector_temp_db_handle$db)

  d <- dbi_copy_to(my_db, 'd',
                   data.frame(AUC = c(NA, 0.5, NA),
                              R2 = c(1.0, 0.9, NA),
                              cat = c("a", NA, "c"),
                              stringsAsFactors = FALSE))

  # numeric example
  op_tree <- d \%.>\% replace_null_cols(., qc(AUC, R2),
                                      0.0)
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  # ad-hoc mode
  data.frame(AUC=c(1,NA,0.5), R2=c(NA,1,0), cat= NA) \%.>\%
     op_tree \%.>\%
     print(.)

  # string example
  op_tree <- d \%.>\% replace_null_cols(., "cat", "")
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  # cleanup
  rm(list = "winvector_temp_db_handle")
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{count_null_cols}}, \code{\link{mark_null_cols}}
}
