% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_counts.R
\name{row_counts}
\alias{row_counts}
\title{Build an optree pipeline counts rows.}
\usage{
row_counts(source, ..., groupby = character(0), env = parent.frame())
}
\arguments{
\item{source}{relop tree or data.frame source.}

\item{...}{force later arguments to bind by name.}

\item{groupby}{partitioning (window function) column names.}

\item{env}{environment to look for values in.}
}
\description{
This is an example of building up a desired pre-prepared pipeline fragment from relop nodes.
}
\examples{

# by hand logistic regression example
d <- mk_td("survey_table",
           c("subjectID", "surveyCategory", "assessmentTotal"))
optree <- d \%.>\%
  row_counts(., groupby = "subjectID")
cat(format(optree))

}
