% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical.R
\name{rray_if_else}
\alias{rray_if_else}
\title{Conditional selection}
\usage{
rray_if_else(condition, true, false)
}
\arguments{
\item{condition}{A logical vector, matrix, array of rray.}

\item{true}{A vector, matrix, array, or rray. This is the value in the result
when \code{condition} is \code{TRUE}.}

\item{false}{A vector, matrix, array, or rray. This is the value in the
result when \code{condition} is \code{FALSE}.}
}
\description{
\code{rray_if_else()} is like \code{ifelse()}, but works with matrices and arrays,
and fully supports broadcasting between the three inputs. Before the
operation is applied, \code{condition} is cast to a logical, and \code{true} and
\code{false} are cast to their common type.
}
\details{
The dimension names of the output are taken as the common names of \code{true}
and \code{false}.
}
\examples{

cond <- c(TRUE, FALSE)

true <- array(
  1:2,
  dimnames = list(c("r1", "r2"))
)

false <- rray(
  c(3, 4, 5, 6),
  dim = c(2, 2),
  dim_names = list(c("rr1", "rr2"), c("c1", "c2"))
)

# - All inputs are broadcast to a common
#   shape of (2, 2).
# - The first row of the output comes from
#   `true`, the second row comes from `false`.
# - The names come from both `true` and `false`.
rray_if_else(cond, true, false)

}
