% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadoc.R
\docType{data}
\name{machines}
\alias{machines}
\title{Computer Hardware}
\format{
A data frame with 209 rows and 8 variables
The variables are as follows:

\itemize{
  \item MMIN: minimum main memory in kilobytes (integer)
  \item MMAX: maximum main memory in kilobytes (integer)
  \item CACH: cache memory in kilobytes (integer)
  \item CHMIN: minimum channels in units (integer)
  \item CHMAX: maximum channels in units (integer)
  \item PRP: published relative performance (integer)
  \item ERP: estimated relative performance from the original article (integer)
}
}
\source{
\href{http://archive.ics.uci.edu/ml/datasets/Computer+Hardware?ref=datanews.io}{UCI Archive}
}
\usage{
data(machines)
}
\description{
A data set containing relative CPU performance data of 209 machines on 8 variables.
 are predictive, one (\code{PRP}) is the goal field and one (\code{ERP}) is the
 linear regression's guess. The estimated relative performance values were
 estimated by the authors using a linear regression method.  See their article
 (Ein-Dor and Feldmesser, CACM 4/87, pp 308-317) for more details on how the
 relative performance values were set.
}
\examples{

 data(machines)

 ## Compute the medcouple of each variable of the Computer hardware data
     data.frame(MC=round(apply(machines, 2, mc),2))

 ## Plot a pairwise scaterplot matrix
     pairs(machines[,1:6])

     mcd <- CovMcd(machines[,1:6])
     plot(mcd, which="pairs")

 ##  Remove the rownames (too long)
     rownames(machines) <- NULL

 ## Start with robust PCA based on MCD (P << n)
     (pca1 <- PcaHubert(machines, k=3))
     plot(pca1, main="ROBPCA-MCD", off=0.03)

 ## PCA with the projection algoritm of Hubert
     (pca2 <- PcaHubert(machines, k=3, mcd=FALSE))
     plot(pca2, main="ROBPCA-SD", off=0.03)

 ## PCA with the adjusted for skewness algorithm of Hubert et al (2009)
     (pca3 <- PcaHubert(machines, k=3, mcd=FALSE, skew=TRUE))
     plot(pca3, main="ROBPCA-AO", off=0.03)

}
\references{
Phillip Ein-Dor and Jacob Feldmesser (1987), Attributes of the performance
     of central processing units: A relative performance prediction model,
     \emph{Communications of the ACM}, \bold{30}, 4, pp 308-317.

 Kibler, D., Aha, D.W. and Albert, M. (1989).  Instance-based prediction
     of real-valued attributes.  \emph{Computational Intelligence}, Vo.l 5,
     51-57.
}
\keyword{datasets}
