/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.ParallelArrayTermVectorMapper;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;

class TermVectorsReader
implements Cloneable {
    static final int FORMAT_VERSION = 2;
    static final int FORMAT_SIZE = 4;
    static final byte STORE_POSITIONS_WITH_TERMVECTOR = 1;
    static final byte STORE_OFFSET_WITH_TERMVECTOR = 2;
    private FieldInfos fieldInfos;
    private IndexInput tvx;
    private IndexInput tvd;
    private IndexInput tvf;
    private int size;
    private int docStoreOffset;
    private int tvdFormat;
    private int tvfFormat;
    static final /* synthetic */ boolean $assertionsDisabled;

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos) throws CorruptIndexException, IOException {
        this(d, segment, fieldInfos, 1024);
    }

    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos, int readBufferSize) throws CorruptIndexException, IOException {
        this(d, segment, fieldInfos, 1024, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermVectorsReader(Directory d, String segment, FieldInfos fieldInfos, int readBufferSize, int docStoreOffset, int size) throws CorruptIndexException, IOException {
        boolean success = false;
        try {
            if (d.fileExists(segment + "." + "tvx")) {
                this.tvx = d.openInput(segment + "." + "tvx", readBufferSize);
                this.checkValidFormat(this.tvx);
                this.tvd = d.openInput(segment + "." + "tvd", readBufferSize);
                this.tvdFormat = this.checkValidFormat(this.tvd);
                this.tvf = d.openInput(segment + "." + "tvf", readBufferSize);
                this.tvfFormat = this.checkValidFormat(this.tvf);
                if (-1 == docStoreOffset) {
                    this.docStoreOffset = 0;
                    this.size = (int)(this.tvx.length() >> 3);
                } else {
                    this.docStoreOffset = docStoreOffset;
                    this.size = size;
                    if (!$assertionsDisabled && (int)(this.tvx.length() / 8L) < size + docStoreOffset) {
                        throw new AssertionError();
                    }
                }
            }
            this.fieldInfos = fieldInfos;
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private int checkValidFormat(IndexInput in) throws CorruptIndexException, IOException {
        int format = in.readInt();
        if (format > 2) {
            throw new CorruptIndexException("Incompatible format version: " + format + " expected " + 2 + " or less");
        }
        return format;
    }

    void close() throws IOException {
        IOException keep;
        block12: {
            block11: {
                block10: {
                    keep = null;
                    if (this.tvx != null) {
                        try {
                            this.tvx.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block10;
                            keep = e;
                        }
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block11;
                        keep = e;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e) {
                    if (keep != null) break block12;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }

    int size() {
        return this.size;
    }

    public void get(int docNum, String field, TermVectorMapper mapper) throws IOException {
        if (this.tvx != null) {
            int i;
            int fieldNumber = this.fieldInfos.fieldNumber(field);
            this.tvx.seek((long)(docNum + this.docStoreOffset) * 8L + 4L);
            long position = this.tvx.readLong();
            this.tvd.seek(position);
            int fieldCount = this.tvd.readVInt();
            int number = 0;
            int found = -1;
            for (i = 0; i < fieldCount; ++i) {
                number = this.tvdFormat == 2 ? this.tvd.readVInt() : (number += this.tvd.readVInt());
                if (number != fieldNumber) continue;
                found = i;
            }
            if (found != -1) {
                position = 0L;
                for (i = 0; i <= found; ++i) {
                    position += this.tvd.readVLong();
                }
                mapper.setDocumentNumber(docNum);
                this.readTermVector(field, position, mapper);
            }
        }
    }

    TermFreqVector get(int docNum, String field) throws IOException {
        ParallelArrayTermVectorMapper mapper = new ParallelArrayTermVectorMapper();
        this.get(docNum, field, mapper);
        return mapper.materializeVector();
    }

    TermFreqVector[] get(int docNum) throws IOException {
        SegmentTermVector[] result = null;
        if (this.tvx != null) {
            this.tvx.seek((long)(docNum + this.docStoreOffset) * 8L + 4L);
            long position = this.tvx.readLong();
            this.tvd.seek(position);
            int fieldCount = this.tvd.readVInt();
            if (fieldCount != 0) {
                int number = 0;
                String[] fields = new String[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    number = this.tvdFormat == 2 ? this.tvd.readVInt() : (number += this.tvd.readVInt());
                    fields[i] = this.fieldInfos.fieldName(number);
                }
                position = 0L;
                long[] tvfPointers = new long[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    tvfPointers[i] = position += this.tvd.readVLong();
                }
                result = this.readTermVectors(docNum, fields, tvfPointers);
            }
        }
        return result;
    }

    public void get(int docNumber, TermVectorMapper mapper) throws IOException {
        if (this.tvx != null) {
            this.tvx.seek((long)docNumber * 8L + 4L);
            long position = this.tvx.readLong();
            this.tvd.seek(position);
            int fieldCount = this.tvd.readVInt();
            if (fieldCount != 0) {
                int number = 0;
                String[] fields = new String[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    number = this.tvdFormat == 2 ? this.tvd.readVInt() : (number += this.tvd.readVInt());
                    fields[i] = this.fieldInfos.fieldName(number);
                }
                position = 0L;
                long[] tvfPointers = new long[fieldCount];
                for (int i = 0; i < fieldCount; ++i) {
                    tvfPointers[i] = position += this.tvd.readVLong();
                }
                mapper.setDocumentNumber(docNumber);
                this.readTermVectors(fields, tvfPointers, mapper);
            }
        }
    }

    private SegmentTermVector[] readTermVectors(int docNum, String[] fields, long[] tvfPointers) throws IOException {
        SegmentTermVector[] res = new SegmentTermVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            ParallelArrayTermVectorMapper mapper = new ParallelArrayTermVectorMapper();
            mapper.setDocumentNumber(docNum);
            this.readTermVector(fields[i], tvfPointers[i], mapper);
            res[i] = (SegmentTermVector)mapper.materializeVector();
        }
        return res;
    }

    private void readTermVectors(String[] fields, long[] tvfPointers, TermVectorMapper mapper) throws IOException {
        for (int i = 0; i < fields.length; ++i) {
            this.readTermVector(fields[i], tvfPointers[i], mapper);
        }
    }

    private void readTermVector(String field, long tvfPointer, TermVectorMapper mapper) throws IOException {
        boolean storeOffsets;
        boolean storePositions;
        this.tvf.seek(tvfPointer);
        int numTerms = this.tvf.readVInt();
        if (numTerms == 0) {
            return;
        }
        if (this.tvfFormat == 2) {
            byte bits = this.tvf.readByte();
            storePositions = (bits & 1) != 0;
            storeOffsets = (bits & 2) != 0;
        } else {
            this.tvf.readVInt();
            storePositions = false;
            storeOffsets = false;
        }
        mapper.setExpectations(field, numTerms, storeOffsets, storePositions);
        int start = 0;
        int deltaLength = 0;
        int totalLength = 0;
        char[] buffer = new char[10];
        char[] previousBuffer = new char[]{};
        for (int i = 0; i < numTerms; ++i) {
            int j;
            start = this.tvf.readVInt();
            totalLength = start + (deltaLength = this.tvf.readVInt());
            if (buffer.length < totalLength) {
                buffer = null;
                buffer = new char[totalLength];
                if (start > 0) {
                    System.arraycopy(previousBuffer, 0, buffer, 0, start);
                }
            }
            this.tvf.readChars(buffer, start, deltaLength);
            String term = new String(buffer, 0, totalLength);
            previousBuffer = buffer;
            int freq = this.tvf.readVInt();
            int[] positions = null;
            if (storePositions) {
                if (!mapper.isIgnoringPositions()) {
                    positions = new int[freq];
                    int prevPosition = 0;
                    for (j = 0; j < freq; ++j) {
                        positions[j] = prevPosition + this.tvf.readVInt();
                        prevPosition = positions[j];
                    }
                } else {
                    for (int j2 = 0; j2 < freq; ++j2) {
                        this.tvf.readVInt();
                    }
                }
            }
            TermVectorOffsetInfo[] offsets = null;
            if (storeOffsets) {
                if (!mapper.isIgnoringOffsets()) {
                    offsets = new TermVectorOffsetInfo[freq];
                    int prevOffset = 0;
                    for (int j3 = 0; j3 < freq; ++j3) {
                        int startOffset = prevOffset + this.tvf.readVInt();
                        int endOffset = startOffset + this.tvf.readVInt();
                        offsets[j3] = new TermVectorOffsetInfo(startOffset, endOffset);
                        prevOffset = endOffset;
                    }
                } else {
                    for (j = 0; j < freq; ++j) {
                        this.tvf.readVInt();
                        this.tvf.readVInt();
                    }
                }
            }
            mapper.map(term, freq, offsets, positions);
        }
    }

    protected Object clone() {
        if (this.tvx == null || this.tvd == null || this.tvf == null) {
            return null;
        }
        TermVectorsReader clone = null;
        try {
            clone = (TermVectorsReader)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.tvx = (IndexInput)this.tvx.clone();
        clone.tvd = (IndexInput)this.tvd.clone();
        clone.tvf = (IndexInput)this.tvf.clone();
        return clone;
    }

    static {
        $assertionsDisabled = !TermVectorsReader.class.desiredAssertionStatus();
    }
}

