/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.DBProp;
import com.hp.hpl.jena.db.impl.DBPropPSet;
import com.hp.hpl.jena.db.impl.SpecializedGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPropLSet
extends DBProp {
    public static Node_URI lSetName = (Node_URI)DB.lSetName.asNode();
    public static Node_URI lSetType = (Node_URI)DB.lSetType.asNode();
    public static Node_URI lSetPSet = (Node_URI)DB.lSetPSet.asNode();

    public DBPropLSet(SpecializedGraph g, String name, String type) {
        super(g);
        this.putPropString(lSetName, name);
        this.putPropString(lSetType, type);
    }

    public DBPropLSet(SpecializedGraph g, Node n) {
        super(g, n);
    }

    public void setPSet(DBPropPSet pset) {
        this.putPropNode(lSetPSet, pset.getNode());
    }

    public String getName() {
        return this.self.getURI().substring(DB.getURI().length());
    }

    public String getType() {
        return this.getPropString(lSetType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBPropPSet getPset() {
        ExtendedIterator<Triple> matches = this.graph.find(this.self, lSetPSet, null, DBPropLSet.newComplete());
        if (matches.hasNext()) {
            try {
                DBPropPSet dBPropPSet = new DBPropPSet(this.graph, ((Triple)matches.next()).getObject());
                return dBPropPSet;
            }
            finally {
                matches.close();
            }
        }
        return null;
    }

    @Override
    public void remove() {
        DBPropPSet pSet = this.getPset();
        if (pSet != null) {
            pSet.remove();
        }
        super.remove();
    }

    public ExtendedIterator<Triple> listTriples() {
        ExtendedIterator<Triple> result = DBProp.listTriples(this.graph, this.self);
        DBPropPSet pset = this.getPset();
        if (pset != null) {
            result = result.andThen(DBProp.listTriples(this.graph, this.getPset().getNode()));
        }
        return result;
    }
}

