/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.enhanced;

import com.hp.hpl.jena.enhanced.AlreadyLinkedViewException;
import com.hp.hpl.jena.enhanced.Personality;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Polymorphic<T> {
    private Polymorphic<T> ring = this;

    Polymorphic() {
    }

    protected abstract Personality<T> getPersonality();

    public <X extends T> boolean supports(Class<X> t) {
        X supporter = this.findExistingView(t);
        return supporter != null || this.canSupport(t);
    }

    protected final <X extends T> X asInternal(Class<X> t) {
        X other = this.findExistingView(t);
        return other == null ? this.convertTo(t) : other;
    }

    private <X extends T> X findExistingView(Class<X> t) {
        Polymorphic<T> r = this;
        do {
            if (!t.isInstance(r) || !r.isValid()) continue;
            return t.cast(r);
        } while ((r = r.ring) != this);
        return null;
    }

    protected <X extends T> boolean alreadyHasView(Class<X> t) {
        return this.findExistingView(t) != null;
    }

    public abstract boolean isValid();

    protected abstract <X extends T> X convertTo(Class<X> var1);

    protected abstract <X extends T> boolean canSupport(Class<X> var1);

    public abstract boolean equals(Object var1);

    public synchronized void addView(Polymorphic<T> other) {
        if (other.ring != other) {
            throw new AlreadyLinkedViewException(other);
        }
        other.ring = this.ring;
        this.ring = other;
    }
}

