/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

abstract class AggMaxBase
extends AggregatorBase {
    protected final Expr expr;

    public AggMaxBase(Expr expr) {
        this.expr = expr;
    }

    protected final Accumulator createAccumulator() {
        return new AccMax(this.expr);
    }

    public final Expr getExpr() {
        return this.expr;
    }

    public final Node getValueEmpty() {
        return null;
    }

    private static class AccMax
    extends AccumulatorExpr {
        private NodeValue maxSoFar = null;
        static final boolean DEBUG = false;

        public AccMax(Expr expr) {
            super(expr);
        }

        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.maxSoFar == null) {
                this.maxSoFar = nv;
                return;
            }
            int x = NodeValue.compareAlways(this.maxSoFar, nv);
            if (x < 0) {
                this.maxSoFar = nv;
            }
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getValue() {
            return this.maxSoFar;
        }
    }
}

