/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.function;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.Function;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionBase
implements Function {
    String uri = null;
    protected ExprList arguments = null;
    protected Binding currentBinding = null;
    private FunctionEnv env;

    @Override
    public final void build(String uri, ExprList args) {
        this.uri = uri;
        this.arguments = args;
        this.checkBuild(uri, args);
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        this.env = env;
        if (args == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        ArrayList<NodeValue> evalArgs = new ArrayList<NodeValue>();
        for (Expr e2 : args) {
            NodeValue x = e2.eval(binding, env);
            evalArgs.add(x);
        }
        this.currentBinding = binding;
        NodeValue nv = this.exec(evalArgs);
        this.currentBinding = null;
        this.arguments = null;
        return nv;
    }

    public Context getContext() {
        return this.env.getContext();
    }

    public abstract NodeValue exec(List<NodeValue> var1);

    public abstract void checkBuild(String var1, ExprList var2);

    public NodeValue getArg(int i) {
        if (--i < 0 || i >= this.arguments.size()) {
            return null;
        }
        return (NodeValue)this.arguments.get(i);
    }
}

