/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.modify.UpdateEngineFactory;
import com.hp.hpl.jena.sparql.modify.UpdateEngineRegistry;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorBase;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateRequest;

public class UpdateExecutionFactory {
    public static UpdateProcessor create(Update update2, GraphStore graphStore) {
        return UpdateExecutionFactory.create(update2, graphStore, (Binding)null);
    }

    public static UpdateProcessor create(Update update2, GraphStore graphStore, QuerySolution initialSolution) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), graphStore, initialSolution);
    }

    public static UpdateProcessor create(Update update2, GraphStore graphStore, Binding initialBinding) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), graphStore, initialBinding);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore) {
        return UpdateExecutionFactory.create(updateRequest, graphStore, (Binding)null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, QuerySolution initialSolution) {
        return UpdateExecutionFactory.create(updateRequest, graphStore, BindingUtils.asBinding(initialSolution));
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, GraphStore graphStore, Binding initialBinding) {
        return UpdateExecutionFactory.make(updateRequest, graphStore, initialBinding, null);
    }

    private static UpdateProcessor make(UpdateRequest updateRequest, GraphStore graphStore, Binding initialBinding, Context context) {
        UpdateEngineFactory f;
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        if ((f = UpdateEngineRegistry.get().find(updateRequest, graphStore, ARQ.getContext())) == null) {
            return null;
        }
        UpdateProcessorBase uProc = new UpdateProcessorBase(updateRequest, graphStore, ARQ.getContext(), f);
        if (initialBinding != null) {
            uProc.setInitialBinding(initialBinding);
        }
        return uProc;
    }
}

