/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.CharStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.io.InputStreamBuffered;

public final class StreamASCII
extends Reader
implements CharStream {
    private InputStreamBuffered input;
    private long count = 0L;

    public StreamASCII(InputStream in) {
        if (in instanceof InputStreamBuffered) {
            this.input = (InputStreamBuffered)in;
            return;
        }
        this.input = new InputStreamBuffered(in);
    }

    public StreamASCII(InputStreamBuffered in) {
        this.input = in;
    }

    public boolean ready() throws IOException {
        return this.input.available() > 0;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void closeStream() {
        IO.close(this.input);
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int x = this.read();
            if (x == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            if (x > 128) {
                throw new AtlasException("Illegal ASCII character : " + x);
            }
            cbuf[i] = (char)x;
        }
        return len;
    }

    public int read() throws IOException {
        return this.advance();
    }

    public int advance() {
        ++this.count;
        return this.input.advance();
    }
}

