% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image2pptx.R
\name{add_image}
\alias{add_image}
\title{Add plot into a document object}
\usage{
add_image(
  mydoc,
  x = NULL,
  preprocessing = "",
  left = 1,
  top = 2,
  width = 8,
  height = 5.5,
  units = "in",
  res = 300,
  format = "emf",
  ...
)
}
\arguments{
\item{mydoc}{A document object}

\item{x}{An string of R code encoding plot}

\item{preprocessing}{A string of R code or ""}

\item{left}{left margin}

\item{top}{top margin}

\item{width}{the width of the device.}

\item{height}{the height of the device.}

\item{units}{The units in which height and width are given. Can be px (pixels, the default), in (inches), cm or mm.}

\item{res}{The nominal resolution in ppi which will be recorded in the bitmap file, if a positive integer. Also used for units other than the default, and to convert points to pixels.}

\item{format}{plot format}

\item{...}{additional arguments passed to png()}
}
\value{
a document object
}
\description{
Add plot into a document object
}
\examples{
require(officer)
require(rrtable)
require(magrittr)
require(ggplot2)
read_pptx() \%>\% add_text(title="Add image") \%>\% add_image("plot(iris)")
read_docx() \%>\% add_text(title="Add image") \%>\% add_image("plot(1:10)",format="png")
}
