% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code2pptx.R
\name{code2office}
\alias{code2office}
\title{Save plot/ggplot code to Microsoft Powerpoint format}
\usage{
code2office(
  ...,
  ggobj = NULL,
  target = "Report",
  append = FALSE,
  title = "",
  type = "pptx",
  preprocessing = "",
  plottype = "auto",
  echo = FALSE,
  parallel = FALSE,
  left = 1,
  top = 1,
  width = NULL,
  height = NULL,
  aspectr = NULL
)
}
\arguments{
\item{...}{Further argument to be passed to function dml()}

\item{ggobj}{a ggplot object}

\item{target}{name of output file}

\item{append}{logical value}

\item{title}{Optional character vector of plot title}

\item{type}{"pptx" or "docx"}

\item{preprocessing}{A string of R code or ""}

\item{plottype}{character  One of c("auto","plot","ggplot","emf")}

\item{echo}{logical. If true, show code.}

\item{parallel}{logical. If true, add two plots side by side}

\item{left}{left margin}

\item{top}{top margin}

\item{width}{desired width of the plot}

\item{height}{desired height of the plot}

\item{aspectr}{desired aspect ratio of the plot}
}
\description{
Save plot/ggplot code to Microsoft Powerpoint format
}
\examples{
\donttest{
code2office(plot(iris))
require(ggplot2)
gg=ggplot(data=mtcars,aes(x=wt,y=mpg))+geom_point()
code2office(ggobj=gg)
}
}
