% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/satscan.R
\name{satscan}
\alias{satscan}
\title{Run SaTScan in the OS}
\usage{
satscan(prmlocation, prmfilename, sslocation = "c:/progra~2/satscan",
  ssbatchfilename = "SaTScanBatch", cleanup = TRUE, verbose = FALSE)
}
\arguments{
\item{prmlocation}{A string containing the
directory location where the paramter file is located.}

\item{prmfilename}{A string containg the name of the parameter file, without the extension, i.e., no ".prm".}

\item{sslocation}{A string containing the directory location where satscanbatch.exe (Windows)
is located.  The default value is a common location in Windows 7.}

\item{ssbatchfilename}{Name of the file containing the SaTScan executable.  This is likely to be
either SaTScanBatch or SaTScanBatch64.  Omit the file extension.}

\item{cleanup}{If true, deletes any SaTScan output files from the OS.}

\item{verbose}{If true, will display the results in the R console as if running SaTScan in batch.  This may be especially
useful if you expect SaTScan to take a long time to run.}
}
\value{
A satscan-class object, which is a list of 8 items, not all of which are always made, depending on SaTScan options and whether the program call was successful or not:
\describe{
  \item{main}{A character vector containing the main text output from SaTScan.  This is
       probably identical to the material displayed when verbose=True}
  \item{col}{A data frame with the basic cluster information dataset SaTScan makes.}
  \item{rr}{A data frame with the risk ratio dataset SaTScan makes.}
  \item{gis}{A data frame with the geographic information dataset SaTScan makes.}
  \item{llr}{A data frame with the log likelihood ratios dataset SaTScan makes.}
  \item{sci}{A data frame with the other cluster information dataset SaTScan makes.}
  \item{shapeclust}{A list object, of class SpatialPolygonsDataFrame, defined by the \code{sp}
  package.  It contains the ESRI shapefile(s) SaTScan makes.  This is made only if the \code{rgdal}
  package is available.}
  \item{prm}{A character vector containing the contents of the parameter file you told SaTScan
  to use.}
}
If an item is not made by SaTScan, it will be NA.
}
\description{
Calls out into the OS to run SaTScan, with the parameter file specified
}
\details{
The parameter file may have been made by the \code{\link{ss.options}} function or not.
If not, or if the \code{matchout = FALSE} parameter was set in \code{ss.options}, then the
return object will include the main text output from SaTScan only you manually set the
\code{ResultsFile} SaTScan parameter to have the same name as the parameter file.
}
\examples{
\dontrun{
## Please see vignette("rsatscan"); example() code doesn't make sense since
## all examples rely on calls to SaTScan in the OS.
}
}
\seealso{
\code{\link{ss.options}}, \code{\link{write.ss.prm}}
}

