% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purgeApp.R
\name{purgeApp}
\alias{purgeApp}
\title{Purge an Application}
\usage{
purgeApp(appName, account = NULL, server = NULL, quiet = FALSE)
}
\arguments{
\item{appName}{Name of application to purge}

\item{account}{Account name. If a single account is registered on the system
then this parameter can be omitted.}

\item{server}{Server name. Required only if you use the same account name on
multiple servers (see \code{\link[=servers]{servers()}})}

\item{quiet}{Request that no status information be printed to the console
during the termination.}
}
\description{
Purge a currently archived ShinyApps application.
}
\note{
This function only works for ShinyApps servers.
}
\examples{
\dontrun{

# purge an application
purgeApp("myapp")
}
}
\seealso{
\code{\link[=applications]{applications()}}, \code{\link[=deployApp]{deployApp()}}, and
\code{\link[=restartApp]{restartApp()}}
}
