% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_retrieval.R
\name{object_retrieval}
\alias{object_retrieval}
\alias{process_object_retrieval}
\alias{download_object}
\alias{download_objects}
\title{ScienceDirect Object Retrieval}
\usage{
object_retrieval(id, identifier = c("scopus_id", "eid", "doi", "pii",
  "pubmed_id"), ref = NULL, http_end = NULL, ...)

process_object_retrieval(res)

download_object(url, api_key = NULL, api_key_error = TRUE,
  verbose = TRUE, ...)

download_objects(url, ...)
}
\arguments{
\item{id}{Identifier for object}

\item{identifier}{Type of identifier to use}

\item{ref}{document reference}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}
or \code{\link{GET}}}

\item{res}{result from \code{\link{object_retrieval}}}

\item{url}{url to download from \code{\link{object_retrieval}}}

\item{api_key}{Elsevier API key}

\item{api_key_error}{Should there be an error if no API key?}

\item{verbose}{Print messages from specification}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to
give a
retrieval of an object from the Elsevier Object Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = object_retrieval("S1053811915002700", identifier = "pii",
   verbose = FALSE)
   df = process_object_retrieval(x)
   df = df[ grepl("image/jpeg", df$mime_type),,drop = FALSE ]
   df = df[ df$type \%in\% "IMAGE-HIGH-RES",,drop = FALSE ]
   res = download_object(df$url[1])
   if (interactive()) {
      browseURL(res$outfile)
   } else {
     img = res$content
     dims = dim(img)[1:2]
     mdim = max(dims)
     graphics::plot(c(0, ncol(img)), c(0, nrow(img)), type='n')
     graphics::rasterImage(img, 1, 1, ncol(img), nrow(img))
   }
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
