% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_retrieval.R
\name{author_retrieval_id}
\alias{author_retrieval_id}
\alias{multi_author_retrieval}
\alias{author_retrieval}
\title{SCOPUS Author Retrieval}
\usage{
author_retrieval_id(id, identifier = c("author_id", "eid"),
  http_end = NULL, ...)

multi_author_retrieval(id, identifier = c("author_id", "eid"),
  http_end = NULL, ...)

author_retrieval(au_id = NULL, last_name = NULL, first_name = NULL,
  view = c("LIGHT", "STANDARD", "ENHANCED", "METRICS", "ENTITLED"),
  self_cite = c("include", "exclude"), http_end = NULL,
  verbose = TRUE, api_key = NULL, headers = NULL, ...)
}
\arguments{
\item{id}{Identifier for author}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to
\code{\link{generic_elsevier_api}}}

\item{au_id}{Author ID number. Overrides any first/last name argument}

\item{last_name}{last name of author}

\item{first_name}{first name of author}

\item{view}{Which view to see.  See
\url{https://api.elsevier.com/documentation/AuthorRetrievalAPI.wadl}}

\item{self_cite}{Should self-citations be included?}

\item{verbose}{Print diagnostic messages}

\item{api_key}{Elsevier API key}

\item{headers}{Headers passed to \code{\link{add_headers}},
passed to \code{\link{GET}}}
}
\value{
List of elements, similar to
\code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}}
to give a
retrieval of an author from the Elsevier Author Retrieval API
}
\note{
See
\url{https://api.elsevier.com/documentation/AuthorRetrievalAPI.wadl}
for documentation
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = author_retrieval(au_id = "40462056100",
   verbose = FALSE)
   x = author_retrieval_id("40462056100", identifier = "author_id",
   verbose = FALSE)
} else {
 x = author_retrieval_id(
 "40462056100",
 identifier = "author_id",
   api_key_error = FALSE, verbose = FALSE)
 x = author_retrieval(
 au_id = "40462056100",
   api_key_error = FALSE, verbose = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
