/* automatically generated by rust-bindgen 0.63.0 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const M_E: f64 = 2.718281828459045;
pub const M_LOG2E: f64 = 1.4426950408889634;
pub const M_LOG10E: f64 = 0.4342944819032518;
pub const M_LN2: f64 = 0.6931471805599453;
pub const M_LN10: f64 = 2.302585092994046;
pub const M_PI: f64 = 3.141592653589793;
pub const M_PI_2: f64 = 1.5707963267948966;
pub const M_PI_4: f64 = 0.7853981633974483;
pub const M_1_PI: f64 = 0.3183098861837907;
pub const M_2_PI: f64 = 0.6366197723675814;
pub const M_2_SQRTPI: f64 = 1.1283791670955126;
pub const M_SQRT2: f64 = 1.4142135623730951;
pub const M_SQRT1_2: f64 = 0.7071067811865476;
pub const SINGLESXP: u32 = 302;
pub const R_XLEN_T_MAX: u64 = 4503599627370496;
pub const R_SHORT_LEN_MAX: u32 = 2147483647;
pub const NILSXP: u32 = 0;
pub const SYMSXP: u32 = 1;
pub const LISTSXP: u32 = 2;
pub const CLOSXP: u32 = 3;
pub const ENVSXP: u32 = 4;
pub const PROMSXP: u32 = 5;
pub const LANGSXP: u32 = 6;
pub const SPECIALSXP: u32 = 7;
pub const BUILTINSXP: u32 = 8;
pub const CHARSXP: u32 = 9;
pub const LGLSXP: u32 = 10;
pub const INTSXP: u32 = 13;
pub const REALSXP: u32 = 14;
pub const CPLXSXP: u32 = 15;
pub const STRSXP: u32 = 16;
pub const DOTSXP: u32 = 17;
pub const ANYSXP: u32 = 18;
pub const VECSXP: u32 = 19;
pub const EXPRSXP: u32 = 20;
pub const BCODESXP: u32 = 21;
pub const EXTPTRSXP: u32 = 22;
pub const WEAKREFSXP: u32 = 23;
pub const RAWSXP: u32 = 24;
pub const S4SXP: u32 = 25;
pub const NEWSXP: u32 = 30;
pub const FREESXP: u32 = 31;
pub const FUNSXP: u32 = 99;
pub const TYPE_BITS: u32 = 5;
pub const MAX_NUM_SEXPTYPE: u32 = 32;
pub const NAMEDMAX: u32 = 7;
pub const R_XDR_DOUBLE_SIZE: u32 = 8;
pub const R_XDR_INTEGER_SIZE: u32 = 4;
pub const R_CODESET_MAX: u32 = 63;
pub const IDENT_NUM_AS_BITS: u32 = 1;
pub const IDENT_NA_AS_BITS: u32 = 2;
pub const IDENT_ATTR_BY_ORDER: u32 = 4;
pub const IDENT_USE_BYTECODE: u32 = 8;
pub const IDENT_USE_CLOENV: u32 = 16;
pub const IDENT_USE_SRCREF: u32 = 32;
pub const IDENT_EXTPTR_AS_REF: u32 = 64;
pub const HT_TYPE_IDENTICAL: u32 = 0;
pub const HT_TYPE_ADDRESS: u32 = 1;
pub const RSTART_VERSION: u32 = 1;
pub const __STDC_WANT_IEC_60559_FUNCS_EXT__: u32 = 1;
pub const R_VERSION_STRING: &[u8; 6usize] = b"4.3.0\0";
pub const HAVE_EXPM1: u32 = 1;
pub const HAVE_HYPOT: u32 = 1;
pub const HAVE_LOG1P: u32 = 1;
pub const HAVE_WORKING_LOG1P: u32 = 1;
pub const M_2PI: f64 = 6.283185307179586;
pub const M_SQRT_3: f64 = 1.7320508075688772;
pub const M_SQRT_32: f64 = 5.656854249492381;
pub const M_LOG10_2: f64 = 0.3010299956639812;
pub const M_SQRT_PI: f64 = 1.772453850905516;
pub const M_1_SQRT_2PI: f64 = 0.3989422804014327;
pub const M_SQRT_2dPI: f64 = 0.7978845608028654;
pub const M_LN_2PI: f64 = 1.8378770664093456;
pub const M_LN_SQRT_PI: f64 = 0.5723649429247001;
pub const M_LN_SQRT_2PI: f64 = 0.9189385332046728;
pub const M_LN_SQRT_PId2: f64 = 0.22579135264472744;
pub const R_VERSION: u32 = 262912;
pub const R_NICK: &[u8; 24usize] = b"Unsuffered Consequences\0";
pub const R_MAJOR: &[u8; 2usize] = b"4\0";
pub const R_MINOR: &[u8; 4usize] = b"3.0\0";
pub const R_STATUS: &[u8; 29usize] = b"Under development (unstable)\0";
pub const R_YEAR: &[u8; 5usize] = b"2023\0";
pub const R_MONTH: &[u8; 3usize] = b"02\0";
pub const R_DAY: &[u8; 3usize] = b"21\0";
pub const R_SVN_REVISION: u32 = 83888;
pub const R_GE_definitions: u32 = 13;
pub const R_GE_deviceClip: u32 = 14;
pub const R_GE_group: u32 = 15;
pub const R_GE_glyphs: u32 = 16;
pub const R_GE_version: u32 = 16;
pub const MAX_GRAPHICS_SYSTEMS: u32 = 24;
pub const R_USE_PROTOTYPES: u32 = 1;
pub const leftButton: u32 = 1;
pub const middleButton: u32 = 2;
pub const rightButton: u32 = 4;
pub const LTY_BLANK: i32 = -1;
pub const LTY_SOLID: u32 = 0;
pub const LTY_DASHED: u32 = 68;
pub const LTY_DOTTED: u32 = 49;
pub const LTY_DOTDASH: u32 = 13361;
pub const LTY_LONGDASH: u32 = 55;
pub const LTY_TWODASH: u32 = 9762;
pub const DEG2RAD: f64 = 0.017453292519943295;
pub const R_GE_linearGradientPattern: u32 = 1;
pub const R_GE_radialGradientPattern: u32 = 2;
pub const R_GE_tilingPattern: u32 = 3;
pub const R_GE_patternExtendPad: u32 = 1;
pub const R_GE_patternExtendRepeat: u32 = 2;
pub const R_GE_patternExtendReflect: u32 = 3;
pub const R_GE_patternExtendNone: u32 = 4;
pub const R_GE_compositeClear: u32 = 1;
pub const R_GE_compositeSource: u32 = 2;
pub const R_GE_compositeOver: u32 = 3;
pub const R_GE_compositeIn: u32 = 4;
pub const R_GE_compositeOut: u32 = 5;
pub const R_GE_compositeAtop: u32 = 6;
pub const R_GE_compositeDest: u32 = 7;
pub const R_GE_compositeDestOver: u32 = 8;
pub const R_GE_compositeDestIn: u32 = 9;
pub const R_GE_compositeDestOut: u32 = 10;
pub const R_GE_compositeDestAtop: u32 = 11;
pub const R_GE_compositeXor: u32 = 12;
pub const R_GE_compositeAdd: u32 = 13;
pub const R_GE_compositeSaturate: u32 = 14;
pub const R_GE_compositeMultiply: u32 = 15;
pub const R_GE_compositeScreen: u32 = 16;
pub const R_GE_compositeOverlay: u32 = 17;
pub const R_GE_compositeDarken: u32 = 18;
pub const R_GE_compositeLighten: u32 = 19;
pub const R_GE_compositeColorDodge: u32 = 20;
pub const R_GE_compositeColorBurn: u32 = 21;
pub const R_GE_compositeHardLight: u32 = 22;
pub const R_GE_compositeSoftLight: u32 = 23;
pub const R_GE_compositeDifference: u32 = 24;
pub const R_GE_compositeExclusion: u32 = 25;
pub const R_GE_nonZeroWindingRule: u32 = 1;
pub const R_GE_evenOddRule: u32 = 2;
pub const R_GE_alphaMask: u32 = 1;
pub const R_GE_luminanceMask: u32 = 2;
pub const R_GE_capability_semiTransparency: u32 = 0;
pub const R_GE_capability_transparentBackground: u32 = 1;
pub const R_GE_capability_rasterImage: u32 = 2;
pub const R_GE_capability_capture: u32 = 3;
pub const R_GE_capability_locator: u32 = 4;
pub const R_GE_capability_events: u32 = 5;
pub const R_GE_capability_patterns: u32 = 6;
pub const R_GE_capability_clippingPaths: u32 = 7;
pub const R_GE_capability_masks: u32 = 8;
pub const R_GE_capability_compositing: u32 = 9;
pub const R_GE_capability_transformations: u32 = 10;
pub const R_GE_capability_paths: u32 = 11;
pub const R_GE_capability_glyphs: u32 = 12;
pub const R_GE_text_style_normal: u32 = 1;
pub const R_GE_text_style_italic: u32 = 2;
pub const R_GE_text_style_oblique: u32 = 3;
#[doc = " <div rustbindgen replaces=\"R_xlen_t\"></div>"]
pub type R_xlen_t = isize;
pub type va_list = __builtin_va_list;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type FILE = _IO_FILE;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    const UNINIT: ::std::mem::MaybeUninit<_IO_FILE> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        concat!("Size of: ", stringify!(_IO_FILE))
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        concat!("Alignment of ", stringify!(_IO_FILE))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_ptr) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_end) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_base) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_read_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_base) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_ptr) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_end) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_write_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_base) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_end) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_buf_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_base) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_backup_base) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_backup_base)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_end) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_IO_save_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._markers) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_markers)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._chain) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_chain)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._fileno) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_fileno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags2) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_flags2)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._old_offset) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_old_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._cur_column) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_cur_column)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._vtable_offset) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_vtable_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._shortbuf) as usize - ptr as usize },
        131usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_shortbuf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._lock) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_lock)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._offset) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._codecvt) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_codecvt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._wide_data) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_wide_data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_list) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_buf) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_freeres_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad5) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(__pad5)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._mode) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._unused2) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_IO_FILE),
            "::",
            stringify!(_unused2)
        )
    );
}
extern "C" {
    pub static mut R_NaN: f64;
}
extern "C" {
    pub static mut R_PosInf: f64;
}
extern "C" {
    pub static mut R_NegInf: f64;
}
extern "C" {
    pub static mut R_NaReal: f64;
}
extern "C" {
    pub static mut R_NaInt: ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_IsNA(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_IsNaN(arg1: f64) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_finite(arg1: f64) -> ::std::os::raw::c_int;
}
pub const Rboolean_FALSE: Rboolean = 0;
pub const Rboolean_TRUE: Rboolean = 1;
pub type Rboolean = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rcomplex {
    pub r: f64,
    pub i: f64,
}
#[test]
fn bindgen_test_layout_Rcomplex() {
    const UNINIT: ::std::mem::MaybeUninit<Rcomplex> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Rcomplex>(),
        16usize,
        concat!("Size of: ", stringify!(Rcomplex))
    );
    assert_eq!(
        ::std::mem::align_of::<Rcomplex>(),
        8usize,
        concat!("Alignment of ", stringify!(Rcomplex))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(Rcomplex),
            "::",
            stringify!(r)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(Rcomplex),
            "::",
            stringify!(i)
        )
    );
}
extern "C" {
    pub fn Rf_error(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn UNIMPLEMENTED(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn WrongArgCount(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn Rf_warning(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn R_ShowMessage(s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn vmaxget() -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn vmaxset(arg1: *const ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_gc();
}
extern "C" {
    pub fn R_gc_running() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_alloc(arg1: usize, arg2: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_allocLD(nelem: usize) -> *mut u128;
}
extern "C" {
    pub fn S_alloc(
        arg1: ::std::os::raw::c_long,
        arg2: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn S_realloc(
        arg1: *mut ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_long,
        arg3: ::std::os::raw::c_long,
        arg4: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_malloc_gc(arg1: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_calloc_gc(arg1: usize, arg2: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_realloc_gc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_isort(arg1: *mut ::std::os::raw::c_int, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_rsort(arg1: *mut f64, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_csort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn rsort_with_index(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_revsort(
        arg1: *mut f64,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_iPsort(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_rPsort(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_cPsort(arg1: *mut Rcomplex, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_qsort(v: *mut f64, i: usize, j: usize);
}
extern "C" {
    pub fn R_qsort_I(
        v: *mut f64,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_qsort_int(iv: *mut ::std::os::raw::c_int, i: usize, j: usize);
}
extern "C" {
    pub fn R_qsort_int_I(
        iv: *mut ::std::os::raw::c_int,
        II: *mut ::std::os::raw::c_int,
        i: ::std::os::raw::c_int,
        j: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_ExpandFileName(arg1: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_setIVector(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_setRVector(arg1: *mut f64, arg2: ::std::os::raw::c_int, arg3: f64);
}
extern "C" {
    pub fn Rf_StringFalse(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_StringTrue(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_isBlankString(arg1: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn R_atof(str_: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn R_strtod(c: *const ::std::os::raw::c_char, end: *mut *mut ::std::os::raw::c_char)
        -> f64;
}
extern "C" {
    pub fn R_tmpnam(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_tmpnam2(
        prefix: *const ::std::os::raw::c_char,
        tempdir: *const ::std::os::raw::c_char,
        fileext: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_free_tmpnam(name: *mut ::std::os::raw::c_char);
}
extern "C" {
    pub fn R_CheckUserInterrupt();
}
extern "C" {
    pub fn R_CheckStack();
}
extern "C" {
    pub fn R_CheckStack2(arg1: usize);
}
extern "C" {
    pub fn findInterval(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn findInterval2(
        xt: *mut f64,
        n: ::std::os::raw::c_int,
        x: f64,
        rightmost_closed: Rboolean,
        all_inside: Rboolean,
        left_open: Rboolean,
        ilo: ::std::os::raw::c_int,
        mflag: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn find_interv_vec(
        xt: *mut f64,
        n: *mut ::std::os::raw::c_int,
        x: *mut f64,
        nx: *mut ::std::os::raw::c_int,
        rightmost_closed: *mut ::std::os::raw::c_int,
        all_inside: *mut ::std::os::raw::c_int,
        indx: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_max_col(
        matrix: *mut f64,
        nr: *mut ::std::os::raw::c_int,
        nc: *mut ::std::os::raw::c_int,
        maxes: *mut ::std::os::raw::c_int,
        ties_meth: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rprintf(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn REprintf(arg1: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rvprintf(arg1: *const ::std::os::raw::c_char, arg2: *mut __va_list_tag);
}
extern "C" {
    pub fn REvprintf(arg1: *const ::std::os::raw::c_char, arg2: *mut __va_list_tag);
}
pub type DL_FUNC = ::std::option::Option<unsafe extern "C" fn() -> *mut ::std::os::raw::c_void>;
pub type R_NativePrimitiveArgType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
    pub types: *mut R_NativePrimitiveArgType,
}
#[test]
fn bindgen_test_layout_R_CMethodDef() {
    const UNINIT: ::std::mem::MaybeUninit<R_CMethodDef> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_CMethodDef>(),
        32usize,
        concat!("Size of: ", stringify!(R_CMethodDef))
    );
    assert_eq!(
        ::std::mem::align_of::<R_CMethodDef>(),
        8usize,
        concat!("Alignment of ", stringify!(R_CMethodDef))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fun) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).numArgs) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(numArgs)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).types) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CMethodDef),
            "::",
            stringify!(types)
        )
    );
}
pub type R_FortranMethodDef = R_CMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_CallMethodDef {
    pub name: *const ::std::os::raw::c_char,
    pub fun: DL_FUNC,
    pub numArgs: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_R_CallMethodDef() {
    const UNINIT: ::std::mem::MaybeUninit<R_CallMethodDef> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_CallMethodDef>(),
        24usize,
        concat!("Size of: ", stringify!(R_CallMethodDef))
    );
    assert_eq!(
        ::std::mem::align_of::<R_CallMethodDef>(),
        8usize,
        concat!("Alignment of ", stringify!(R_CallMethodDef))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fun) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(fun)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).numArgs) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_CallMethodDef),
            "::",
            stringify!(numArgs)
        )
    );
}
pub type R_ExternalMethodDef = R_CallMethodDef;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DllInfo {
    _unused: [u8; 0],
}
pub type DllInfo = _DllInfo;
extern "C" {
    pub fn R_registerRoutines(
        info: *mut DllInfo,
        croutines: *const R_CMethodDef,
        callRoutines: *const R_CallMethodDef,
        fortranRoutines: *const R_FortranMethodDef,
        externalRoutines: *const R_ExternalMethodDef,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_useDynamicSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn R_forceSymbols(info: *mut DllInfo, value: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn R_getDllInfo(name: *const ::std::os::raw::c_char) -> *mut DllInfo;
}
extern "C" {
    pub fn R_getEmbeddingDllInfo() -> *mut DllInfo;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Rf_RegisteredNativeSymbol {
    _unused: [u8; 0],
}
pub type R_RegisteredNativeSymbol = Rf_RegisteredNativeSymbol;
pub const NativeSymbolType_R_ANY_SYM: NativeSymbolType = 0;
pub const NativeSymbolType_R_C_SYM: NativeSymbolType = 1;
pub const NativeSymbolType_R_CALL_SYM: NativeSymbolType = 2;
pub const NativeSymbolType_R_FORTRAN_SYM: NativeSymbolType = 3;
pub const NativeSymbolType_R_EXTERNAL_SYM: NativeSymbolType = 4;
pub type NativeSymbolType = ::std::os::raw::c_uint;
extern "C" {
    pub fn R_FindSymbol(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        symbol: *mut R_RegisteredNativeSymbol,
    ) -> DL_FUNC;
}
extern "C" {
    pub fn R_RegisterCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
        fptr: DL_FUNC,
    );
}
extern "C" {
    pub fn R_GetCCallable(
        package: *const ::std::os::raw::c_char,
        name: *const ::std::os::raw::c_char,
    ) -> DL_FUNC;
}
pub type Rbyte = ::std::os::raw::c_uchar;
pub type R_len_t = ::std::os::raw::c_int;
pub type SEXPTYPE = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct SEXPREC {
    _unused: [u8; 0],
}
pub type SEXP = *mut SEXPREC;
extern "C" {
    pub fn R_CHAR(x: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_isNull(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isSymbol(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isLogical(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isReal(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isComplex(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isExpression(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isEnvironment(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isString(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isObject(s: SEXP) -> Rboolean;
}
extern "C" {
    pub fn ATTRIB(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn OBJECT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MARK(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TYPEOF(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn NAMED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REFCNT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_ATTRIB(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
}
extern "C" {
    pub fn SHALLOW_DUPLICATE_ATTRIB(to: SEXP, from: SEXP);
}
extern "C" {
    pub fn MARK_NOT_MUTABLE(x: SEXP);
}
extern "C" {
    pub fn IS_S4_OBJECT(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LENGTH(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn XLENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn TRUELENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn IS_LONG_VEC(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LEVELS(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn RAW(x: SEXP) -> *mut Rbyte;
}
extern "C" {
    pub fn REAL(x: SEXP) -> *mut f64;
}
extern "C" {
    pub fn COMPLEX(x: SEXP) -> *mut Rcomplex;
}
extern "C" {
    pub fn LOGICAL_RO(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_RO(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn RAW_RO(x: SEXP) -> *const Rbyte;
}
extern "C" {
    pub fn REAL_RO(x: SEXP) -> *const f64;
}
extern "C" {
    pub fn COMPLEX_RO(x: SEXP) -> *const Rcomplex;
}
extern "C" {
    pub fn VECTOR_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn SET_STRING_ELT(x: SEXP, i: R_xlen_t, v: SEXP);
}
extern "C" {
    pub fn SET_VECTOR_ELT(x: SEXP, i: R_xlen_t, v: SEXP) -> SEXP;
}
extern "C" {
    pub fn STRING_PTR(x: SEXP) -> *mut SEXP;
}
extern "C" {
    pub fn STRING_PTR_RO(x: SEXP) -> *const SEXP;
}
extern "C" {
    pub fn VECTOR_PTR(x: SEXP) -> *mut SEXP;
}
extern "C" {
    pub fn INTEGER_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
}
extern "C" {
    pub fn REAL_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut f64) -> R_xlen_t;
}
extern "C" {
    pub fn LOGICAL_GET_REGION(
        sx: SEXP,
        i: R_xlen_t,
        n: R_xlen_t,
        buf: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t;
}
extern "C" {
    pub fn COMPLEX_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rcomplex) -> R_xlen_t;
}
extern "C" {
    pub fn RAW_GET_REGION(sx: SEXP, i: R_xlen_t, n: R_xlen_t, buf: *mut Rbyte) -> R_xlen_t;
}
extern "C" {
    pub fn INTEGER_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn LOGICAL_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn STRING_IS_SORTED(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn STRING_NO_NA(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn TAG(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CDDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CADDDR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAD4R(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn CAD5R(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn MISSING(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_TAG(x: SEXP, y: SEXP);
}
extern "C" {
    pub fn SETCAR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCADDDR(x: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn SETCAD4R(e: SEXP, y: SEXP) -> SEXP;
}
extern "C" {
    pub fn FORMALS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn BODY(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn CLOENV(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn RDEBUG(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RSTEP(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RTRACE(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_RDEBUG(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_RSTEP(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_RTRACE(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_FORMALS(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_BODY(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_CLOENV(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn PRINTNAME(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn SYMVALUE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn INTERNAL(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn DDVAL(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn FRAME(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ENCLOS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn HASHTAB(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn ENVFLAGS(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PRCODE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRENV(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRVALUE(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn PRSEEN(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn EXTPTR_PROT(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn EXTPTR_TAG(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn EXTPTR_PTR(arg1: SEXP) -> *mut ::std::os::raw::c_void;
}
pub type PROTECT_INDEX = ::std::os::raw::c_int;
extern "C" {
    pub static mut R_GlobalEnv: SEXP;
}
extern "C" {
    pub static mut R_EmptyEnv: SEXP;
}
extern "C" {
    pub static mut R_BaseEnv: SEXP;
}
extern "C" {
    pub static mut R_BaseNamespace: SEXP;
}
extern "C" {
    pub static mut R_NamespaceRegistry: SEXP;
}
extern "C" {
    pub static mut R_Srcref: SEXP;
}
extern "C" {
    pub static mut R_NilValue: SEXP;
}
extern "C" {
    pub static mut R_UnboundValue: SEXP;
}
extern "C" {
    pub static mut R_MissingArg: SEXP;
}
extern "C" {
    pub static mut R_InBCInterpreter: SEXP;
}
extern "C" {
    pub static mut R_CurrentExpression: SEXP;
}
extern "C" {
    pub static mut R_RestartToken: SEXP;
}
extern "C" {
    pub static mut R_AsCharacterSymbol: SEXP;
}
extern "C" {
    pub static mut R_AtsignSymbol: SEXP;
}
extern "C" {
    pub static mut R_baseSymbol: SEXP;
}
extern "C" {
    pub static mut R_BaseSymbol: SEXP;
}
extern "C" {
    pub static mut R_BraceSymbol: SEXP;
}
extern "C" {
    pub static mut R_Bracket2Symbol: SEXP;
}
extern "C" {
    pub static mut R_BracketSymbol: SEXP;
}
extern "C" {
    pub static mut R_ClassSymbol: SEXP;
}
extern "C" {
    pub static mut R_DeviceSymbol: SEXP;
}
extern "C" {
    pub static mut R_DimNamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_DimSymbol: SEXP;
}
extern "C" {
    pub static mut R_DollarSymbol: SEXP;
}
extern "C" {
    pub static mut R_DotsSymbol: SEXP;
}
extern "C" {
    pub static mut R_DoubleColonSymbol: SEXP;
}
extern "C" {
    pub static mut R_DropSymbol: SEXP;
}
extern "C" {
    pub static mut R_EvalSymbol: SEXP;
}
extern "C" {
    pub static mut R_FunctionSymbol: SEXP;
}
extern "C" {
    pub static mut R_LastvalueSymbol: SEXP;
}
extern "C" {
    pub static mut R_LevelsSymbol: SEXP;
}
extern "C" {
    pub static mut R_ModeSymbol: SEXP;
}
extern "C" {
    pub static mut R_NaRmSymbol: SEXP;
}
extern "C" {
    pub static mut R_NameSymbol: SEXP;
}
extern "C" {
    pub static mut R_NamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_NamespaceEnvSymbol: SEXP;
}
extern "C" {
    pub static mut R_PackageSymbol: SEXP;
}
extern "C" {
    pub static mut R_PreviousSymbol: SEXP;
}
extern "C" {
    pub static mut R_QuoteSymbol: SEXP;
}
extern "C" {
    pub static mut R_RowNamesSymbol: SEXP;
}
extern "C" {
    pub static mut R_SeedsSymbol: SEXP;
}
extern "C" {
    pub static mut R_SortListSymbol: SEXP;
}
extern "C" {
    pub static mut R_SourceSymbol: SEXP;
}
extern "C" {
    pub static mut R_SpecSymbol: SEXP;
}
extern "C" {
    pub static mut R_TripleColonSymbol: SEXP;
}
extern "C" {
    pub static mut R_TspSymbol: SEXP;
}
extern "C" {
    pub static mut R_dot_defined: SEXP;
}
extern "C" {
    pub static mut R_dot_Method: SEXP;
}
extern "C" {
    pub static mut R_dot_packageName: SEXP;
}
extern "C" {
    pub static mut R_dot_target: SEXP;
}
extern "C" {
    pub static mut R_dot_Generic: SEXP;
}
extern "C" {
    pub static mut R_NaString: SEXP;
}
extern "C" {
    pub static mut R_BlankString: SEXP;
}
extern "C" {
    pub static mut R_BlankScalarString: SEXP;
}
extern "C" {
    pub fn R_GetCurrentSrcref(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_GetSrcFilename(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_coerceVector(arg1: SEXP, arg2: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_PairToVectorList(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_VectorToPairList(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asCharacterFactor(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_asLogical(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_asInteger(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_asReal(x: SEXP) -> f64;
}
extern "C" {
    pub fn Rf_asComplex(x: SEXP) -> Rcomplex;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_allocator {
    _unused: [u8; 0],
}
pub type R_allocator_t = R_allocator;
extern "C" {
    pub fn Rf_acopy_string(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_alloc3DArray(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_allocArray(arg1: SEXPTYPE, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_allocMatrix(
        arg1: SEXPTYPE,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_allocList(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_allocS4Object() -> SEXP;
}
extern "C" {
    pub fn Rf_allocSExp(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_allocVector3(arg1: SEXPTYPE, arg2: R_xlen_t, arg3: *mut R_allocator_t) -> SEXP;
}
extern "C" {
    pub fn Rf_any_duplicated(x: SEXP, from_last: Rboolean) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_any_duplicated3(x: SEXP, incomp: SEXP, from_last: Rboolean) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_applyClosure(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_classgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_cons(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_copyMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
}
extern "C" {
    pub fn Rf_copyListMatrix(arg1: SEXP, arg2: SEXP, arg3: Rboolean);
}
extern "C" {
    pub fn Rf_copyMostAttrib(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_copyVector(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_defineVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_dimgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_dimnamesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_shallow_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_duplicate_attr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_shallow_duplicate_attr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lazy_duplicate(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_duplicated(arg1: SEXP, arg2: Rboolean) -> SEXP;
}
extern "C" {
    pub fn Rf_eval(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findFun(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findVar(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findVarInFrame(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_findVarInFrame3(arg1: SEXP, arg2: SEXP, arg3: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_existsVarInFrame(arg1: SEXP, arg2: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_removeVarFromFrame(arg1: SEXP, arg2: SEXP);
}
extern "C" {
    pub fn Rf_getAttrib(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetArrayDimnames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetColNames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetMatrixDimnames(
        arg1: SEXP,
        arg2: *mut SEXP,
        arg3: *mut SEXP,
        arg4: *mut *const ::std::os::raw::c_char,
        arg5: *mut *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn Rf_GetOption(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetOption1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_GetOptionDigits() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_GetOptionWidth() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_GetRowNames(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_gsetVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_install(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_installChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_installNoTrChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_installTrChar(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_isOrdered(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUnordered(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUnsorted(arg1: SEXP, arg2: Rboolean) -> Rboolean;
}
extern "C" {
    pub fn Rf_lengthgets(arg1: SEXP, arg2: R_len_t) -> SEXP;
}
extern "C" {
    pub fn Rf_xlengthgets(arg1: SEXP, arg2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn R_lsInternal(arg1: SEXP, arg2: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_lsInternal3(arg1: SEXP, arg2: Rboolean, arg3: Rboolean) -> SEXP;
}
extern "C" {
    pub fn Rf_match(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_namesgets(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_mkChar(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_mkCharLen(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_NonNullStringMatch(arg1: SEXP, arg2: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_ncols(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nrows(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nthcdr(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
}
pub const nchar_type_Bytes: nchar_type = 0;
pub const nchar_type_Chars: nchar_type = 1;
pub const nchar_type_Width: nchar_type = 2;
pub type nchar_type = ::std::os::raw::c_uint;
extern "C" {
    pub fn R_nchar(
        string: SEXP,
        type_: nchar_type,
        allowNA: Rboolean,
        keepNA: Rboolean,
        msg_name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_ParseEvalString(arg1: *const ::std::os::raw::c_char, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_PrintValue(arg1: SEXP);
}
extern "C" {
    pub fn Rf_setAttrib(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_setVar(arg1: SEXP, arg2: SEXP, arg3: SEXP);
}
extern "C" {
    pub fn Rf_str2type(arg1: *const ::std::os::raw::c_char) -> SEXPTYPE;
}
extern "C" {
    pub fn Rf_StringBlank(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_substitute(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_topenv(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_translateChar(arg1: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_translateCharUTF8(arg1: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_type2char(arg1: SEXPTYPE) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_type2rstr(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_type2str(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_type2str_nowarn(arg1: SEXPTYPE) -> SEXP;
}
extern "C" {
    pub fn Rf_unprotect_ptr(arg1: SEXP);
}
extern "C" {
    pub fn R_tryEval(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_tryEvalSilent(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_GetCurrentEnv() -> SEXP;
}
extern "C" {
    pub fn Rf_isS4(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_asS4(arg1: SEXP, arg2: Rboolean, arg3: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_S3Class(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_isBasicClass(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub const cetype_t_CE_NATIVE: cetype_t = 0;
pub const cetype_t_CE_UTF8: cetype_t = 1;
pub const cetype_t_CE_LATIN1: cetype_t = 2;
pub const cetype_t_CE_BYTES: cetype_t = 3;
pub const cetype_t_CE_SYMBOL: cetype_t = 5;
pub const cetype_t_CE_ANY: cetype_t = 99;
pub type cetype_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn Rf_getCharCE(arg1: SEXP) -> cetype_t;
}
extern "C" {
    pub fn Rf_mkCharCE(arg1: *const ::std::os::raw::c_char, arg2: cetype_t) -> SEXP;
}
extern "C" {
    pub fn Rf_mkCharLenCE(
        arg1: *const ::std::os::raw::c_char,
        arg2: ::std::os::raw::c_int,
        arg3: cetype_t,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_reEnc(
        x: *const ::std::os::raw::c_char,
        ce_in: cetype_t,
        ce_out: cetype_t,
        subst: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_reEnc3(
        x: *const ::std::os::raw::c_char,
        fromcode: *const ::std::os::raw::c_char,
        tocode: *const ::std::os::raw::c_char,
        subst: ::std::os::raw::c_int,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_forceAndCall(e: SEXP, n: ::std::os::raw::c_int, rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_MakeExternalPtr(p: *mut ::std::os::raw::c_void, tag: SEXP, prot: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrAddr(s: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_ExternalPtrTag(s: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrProtected(s: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ClearExternalPtr(s: SEXP);
}
extern "C" {
    pub fn R_SetExternalPtrAddr(s: SEXP, p: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_SetExternalPtrTag(s: SEXP, tag: SEXP);
}
extern "C" {
    pub fn R_SetExternalPtrProtected(s: SEXP, p: SEXP);
}
extern "C" {
    pub fn R_MakeExternalPtrFn(p: DL_FUNC, tag: SEXP, prot: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ExternalPtrAddrFn(s: SEXP) -> DL_FUNC;
}
pub type R_CFinalizer_t = ::std::option::Option<unsafe extern "C" fn(arg1: SEXP)>;
extern "C" {
    pub fn R_RegisterFinalizer(s: SEXP, fun: SEXP);
}
extern "C" {
    pub fn R_RegisterCFinalizer(s: SEXP, fun: R_CFinalizer_t);
}
extern "C" {
    pub fn R_RegisterFinalizerEx(s: SEXP, fun: SEXP, onexit: Rboolean);
}
extern "C" {
    pub fn R_RegisterCFinalizerEx(s: SEXP, fun: R_CFinalizer_t, onexit: Rboolean);
}
extern "C" {
    pub fn R_RunPendingFinalizers();
}
extern "C" {
    pub fn R_MakeWeakRef(key: SEXP, val: SEXP, fin: SEXP, onexit: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_MakeWeakRefC(key: SEXP, val: SEXP, fin: R_CFinalizer_t, onexit: Rboolean) -> SEXP;
}
extern "C" {
    pub fn R_WeakRefKey(w: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_WeakRefValue(w: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_RunWeakRefFinalizer(w: SEXP);
}
extern "C" {
    pub fn R_PromiseExpr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ClosureExpr(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_BytecodeExpr(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_ToplevelExec(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        data: *mut ::std::os::raw::c_void,
    ) -> Rboolean;
}
extern "C" {
    pub fn R_ExecWithCleanup(
        fun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        cleandata: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_tryCatch(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: SEXP,
        arg4: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg5: *mut ::std::os::raw::c_void,
        arg6: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
        arg7: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_tryCatchError(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_withCallingErrorHandler(
        arg1: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: *mut ::std::os::raw::c_void) -> SEXP,
        >,
        arg4: *mut ::std::os::raw::c_void,
    ) -> SEXP;
}
extern "C" {
    pub fn R_MakeUnwindCont() -> SEXP;
}
extern "C" {
    pub fn R_ContinueUnwind(cont: SEXP);
}
extern "C" {
    pub fn R_UnwindProtect(
        fun: ::std::option::Option<unsafe extern "C" fn(data: *mut ::std::os::raw::c_void) -> SEXP>,
        data: *mut ::std::os::raw::c_void,
        cleanfun: ::std::option::Option<
            unsafe extern "C" fn(data: *mut ::std::os::raw::c_void, jump: Rboolean),
        >,
        cleandata: *mut ::std::os::raw::c_void,
        cont: SEXP,
    ) -> SEXP;
}
extern "C" {
    pub fn R_NewEnv(arg1: SEXP, arg2: ::std::os::raw::c_int, arg3: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_IsPackageEnv(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_PackageEnvName(rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_FindPackageEnv(info: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_IsNamespaceEnv(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_NamespaceEnvSpec(rho: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_FindNamespace(info: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_LockEnvironment(env: SEXP, bindings: Rboolean);
}
extern "C" {
    pub fn R_EnvironmentIsLocked(env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_LockBinding(sym: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_unLockBinding(sym: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_MakeActiveBinding(sym: SEXP, fun: SEXP, env: SEXP);
}
extern "C" {
    pub fn R_BindingIsLocked(sym: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_BindingIsActive(sym: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_ActiveBindingFunction(sym: SEXP, env: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_HasFancyBindings(rho: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_errorcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rf_warningcall(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn Rf_warningcall_immediate(arg1: SEXP, arg2: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn R_XDREncodeDouble(d: f64, buf: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_XDRDecodeDouble(buf: *mut ::std::os::raw::c_void) -> f64;
}
extern "C" {
    pub fn R_XDREncodeInteger(i: ::std::os::raw::c_int, buf: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn R_XDRDecodeInteger(buf: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
pub type R_pstream_data_t = *mut ::std::os::raw::c_void;
pub const R_pstream_format_t_R_pstream_any_format: R_pstream_format_t = 0;
pub const R_pstream_format_t_R_pstream_ascii_format: R_pstream_format_t = 1;
pub const R_pstream_format_t_R_pstream_binary_format: R_pstream_format_t = 2;
pub const R_pstream_format_t_R_pstream_xdr_format: R_pstream_format_t = 3;
pub const R_pstream_format_t_R_pstream_asciihex_format: R_pstream_format_t = 4;
pub type R_pstream_format_t = ::std::os::raw::c_uint;
pub type R_outpstream_t = *mut R_outpstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_outpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub version: ::std::os::raw::c_int,
    pub OutChar: ::std::option::Option<
        unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
    >,
    pub OutBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_outpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub OutPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub OutPersistHookData: SEXP,
}
#[test]
fn bindgen_test_layout_R_outpstream_st() {
    const UNINIT: ::std::mem::MaybeUninit<R_outpstream_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_outpstream_st>(),
        48usize,
        concat!("Size of: ", stringify!(R_outpstream_st))
    );
    assert_eq!(
        ::std::mem::align_of::<R_outpstream_st>(),
        8usize,
        concat!("Alignment of ", stringify!(R_outpstream_st))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).OutChar) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutChar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).OutBytes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutBytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).OutPersistHookFunc) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutPersistHookFunc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).OutPersistHookData) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_outpstream_st),
            "::",
            stringify!(OutPersistHookData)
        )
    );
}
pub type R_inpstream_t = *mut R_inpstream_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_inpstream_st {
    pub data: R_pstream_data_t,
    pub type_: R_pstream_format_t,
    pub InChar:
        ::std::option::Option<unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int>,
    pub InBytes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: R_inpstream_t,
            arg2: *mut ::std::os::raw::c_void,
            arg3: ::std::os::raw::c_int,
        ),
    >,
    pub InPersistHookFunc:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
    pub InPersistHookData: SEXP,
    pub native_encoding: [::std::os::raw::c_char; 64usize],
    pub nat2nat_obj: *mut ::std::os::raw::c_void,
    pub nat2utf8_obj: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_R_inpstream_st() {
    const UNINIT: ::std::mem::MaybeUninit<R_inpstream_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_inpstream_st>(),
        128usize,
        concat!("Size of: ", stringify!(R_inpstream_st))
    );
    assert_eq!(
        ::std::mem::align_of::<R_inpstream_st>(),
        8usize,
        concat!("Alignment of ", stringify!(R_inpstream_st))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).InChar) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InChar)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).InBytes) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InBytes)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).InPersistHookFunc) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InPersistHookFunc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).InPersistHookData) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(InPersistHookData)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).native_encoding) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(native_encoding)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nat2nat_obj) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(nat2nat_obj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nat2utf8_obj) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(R_inpstream_st),
            "::",
            stringify!(nat2utf8_obj)
        )
    );
}
extern "C" {
    pub fn R_InitInPStream(
        stream: R_inpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        inchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_inpstream_t) -> ::std::os::raw::c_int,
        >,
        inbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_inpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitOutPStream(
        stream: R_outpstream_t,
        data: R_pstream_data_t,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        outchar: ::std::option::Option<
            unsafe extern "C" fn(arg1: R_outpstream_t, arg2: ::std::os::raw::c_int),
        >,
        outbytes: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: R_outpstream_t,
                arg2: *mut ::std::os::raw::c_void,
                arg3: ::std::os::raw::c_int,
            ),
        >,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitFileInPStream(
        stream: R_inpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_InitFileOutPStream(
        stream: R_outpstream_t,
        fp: *mut FILE,
        type_: R_pstream_format_t,
        version: ::std::os::raw::c_int,
        phook: ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>,
        pdata: SEXP,
    );
}
extern "C" {
    pub fn R_Serialize(s: SEXP, ops: R_outpstream_t);
}
extern "C" {
    pub fn R_Unserialize(ips: R_inpstream_t) -> SEXP;
}
extern "C" {
    pub fn R_SerializeInfo(ips: R_inpstream_t) -> SEXP;
}
extern "C" {
    pub fn R_do_slot(obj: SEXP, name: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_do_slot_assign(obj: SEXP, name: SEXP, value: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_has_slot(obj: SEXP, name: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_S4_extends(klass: SEXP, useTable: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_do_MAKE_CLASS(what: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn R_getClassDef(what: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn R_getClassDef_R(what: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_has_methods_attached() -> Rboolean;
}
extern "C" {
    pub fn R_isVirtualClass(class_def: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_extends(class1: SEXP, class2: SEXP, env: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_do_new_object(class_def: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_check_class_and_super(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
        rho: SEXP,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_check_class_etc(
        x: SEXP,
        valid: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_PreserveObject(arg1: SEXP);
}
extern "C" {
    pub fn R_ReleaseObject(arg1: SEXP);
}
extern "C" {
    pub fn R_NewPreciousMSet(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn R_PreserveInMSet(x: SEXP, mset: SEXP);
}
extern "C" {
    pub fn R_ReleaseFromMSet(x: SEXP, mset: SEXP);
}
extern "C" {
    pub fn R_ReleaseMSet(mset: SEXP, keepSize: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_dot_Last();
}
extern "C" {
    pub fn R_RunExitFinalizers();
}
extern "C" {
    pub fn R_system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_compute_identical(arg1: SEXP, arg2: SEXP, arg3: ::std::os::raw::c_int) -> Rboolean;
}
extern "C" {
    pub fn R_body_no_src(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_orderVector(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        arglist: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
}
extern "C" {
    pub fn R_orderVector1(
        indx: *mut ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        x: SEXP,
        nalast: Rboolean,
        decreasing: Rboolean,
    );
}
extern "C" {
    pub fn Rf_allocVector(arg1: SEXPTYPE, arg2: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn Rf_conformable(arg1: SEXP, arg2: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_elt(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_inherits(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> Rboolean;
}
extern "C" {
    pub fn Rf_isArray(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFactor(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFrame(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isFunction(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isInteger(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isLanguage(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isMatrix(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNewList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNumber(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isNumeric(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isPairList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isPrimitive(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isTs(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isUserBinop(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isValidString(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isValidStringF(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVector(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorAtomic(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorList(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_isVectorizable(arg1: SEXP) -> Rboolean;
}
extern "C" {
    pub fn Rf_lang1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang2(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lang6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
}
extern "C" {
    pub fn Rf_lastElt(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_lcons(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_length(arg1: SEXP) -> R_len_t;
}
extern "C" {
    pub fn Rf_list1(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list2(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list3(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list4(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list5(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_list6(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP, arg5: SEXP, arg6: SEXP)
        -> SEXP;
}
extern "C" {
    pub fn Rf_listAppend(arg1: SEXP, arg2: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_mkNamed(arg1: SEXPTYPE, arg2: *mut *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_mkString(arg1: *const ::std::os::raw::c_char) -> SEXP;
}
extern "C" {
    pub fn Rf_nlevels(arg1: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_stringPositionTr(
        arg1: SEXP,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_ScalarComplex(arg1: Rcomplex) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarInteger(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarLogical(arg1: ::std::os::raw::c_int) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarRaw(arg1: Rbyte) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarReal(arg1: f64) -> SEXP;
}
extern "C" {
    pub fn Rf_ScalarString(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_xlength(arg1: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn XTRUELENGTH(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn LENGTH_EX(
        x: SEXP,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn XLENGTH_EX(x: SEXP) -> R_xlen_t;
}
extern "C" {
    pub fn Rf_protect(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub fn Rf_unprotect(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_ProtectWithIndex(arg1: SEXP, arg2: *mut PROTECT_INDEX);
}
extern "C" {
    pub fn R_Reprotect(arg1: SEXP, arg2: PROTECT_INDEX);
}
extern "C" {
    pub fn CAR(e: SEXP) -> SEXP;
}
extern "C" {
    pub fn DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn DATAPTR_RO(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn DATAPTR_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_void;
}
extern "C" {
    pub fn LOGICAL_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER_OR_NULL(x: SEXP) -> *const ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_OR_NULL(x: SEXP) -> *const f64;
}
extern "C" {
    pub fn COMPLEX_OR_NULL(x: SEXP) -> *const Rcomplex;
}
extern "C" {
    pub fn RAW_OR_NULL(x: SEXP) -> *const Rbyte;
}
extern "C" {
    pub fn INTEGER_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL_ELT(x: SEXP, i: R_xlen_t) -> f64;
}
extern "C" {
    pub fn LOGICAL_ELT(x: SEXP, i: R_xlen_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn COMPLEX_ELT(x: SEXP, i: R_xlen_t) -> Rcomplex;
}
extern "C" {
    pub fn RAW_ELT(x: SEXP, i: R_xlen_t) -> Rbyte;
}
extern "C" {
    pub fn STRING_ELT(x: SEXP, i: R_xlen_t) -> SEXP;
}
extern "C" {
    pub fn SET_LOGICAL_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_INTEGER_ELT(x: SEXP, i: R_xlen_t, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_REAL_ELT(x: SEXP, i: R_xlen_t, v: f64);
}
extern "C" {
    pub fn SET_COMPLEX_ELT(x: SEXP, i: R_xlen_t, v: Rcomplex);
}
extern "C" {
    pub fn SET_RAW_ELT(x: SEXP, i: R_xlen_t, v: Rbyte);
}
extern "C" {
    pub fn ALTREP_CLASS(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_altrep_data1(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_altrep_data2(x: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_set_altrep_data1(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn R_set_altrep_data2(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn LOGICAL0(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn INTEGER0(x: SEXP) -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn REAL0(x: SEXP) -> *mut f64;
}
extern "C" {
    pub fn COMPLEX0(x: SEXP) -> *mut Rcomplex;
}
extern "C" {
    pub fn RAW0(x: SEXP) -> *mut Rbyte;
}
extern "C" {
    pub fn ALTREP(x: SEXP) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_hashtab_type {
    pub cell: SEXP,
}
#[test]
fn bindgen_test_layout_R_hashtab_type() {
    const UNINIT: ::std::mem::MaybeUninit<R_hashtab_type> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_hashtab_type>(),
        8usize,
        concat!("Size of: ", stringify!(R_hashtab_type))
    );
    assert_eq!(
        ::std::mem::align_of::<R_hashtab_type>(),
        8usize,
        concat!("Alignment of ", stringify!(R_hashtab_type))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cell) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_hashtab_type),
            "::",
            stringify!(cell)
        )
    );
}
extern "C" {
    pub fn R_asHashtable(h: SEXP) -> R_hashtab_type;
}
extern "C" {
    pub fn R_HashtabSEXP(h: R_hashtab_type) -> SEXP;
}
extern "C" {
    pub fn R_isHashtable(h: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_mkhashtab(type_: ::std::os::raw::c_int, arg1: ::std::os::raw::c_int)
        -> R_hashtab_type;
}
extern "C" {
    pub fn R_gethash(h: R_hashtab_type, key: SEXP, nomatch: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_sethash(h: R_hashtab_type, key: SEXP, value: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_remhash(h: R_hashtab_type, key: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_numhash(h: R_hashtab_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_typhash(h: R_hashtab_type) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_maphash(h: R_hashtab_type, FUN: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_maphashC(
        h: R_hashtab_type,
        FUN: ::std::option::Option<
            unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: *mut ::std::os::raw::c_void),
        >,
        data: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn R_clrhash(h: R_hashtab_type);
}
extern "C" {
    pub fn SET_TYPEOF(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_OBJECT(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_S4_OBJECT(x: SEXP);
}
extern "C" {
    pub fn UNSET_S4_OBJECT(x: SEXP);
}
extern "C" {
    pub fn R_curErrorBuf() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn IS_SCALAR(x: SEXP, type_: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_psmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: Rboolean,
    ) -> Rboolean;
}
extern "C" {
    pub fn SETLENGTH(x: SEXP, v: R_xlen_t);
}
extern "C" {
    pub fn SET_TRUELENGTH(x: SEXP, v: R_xlen_t);
}
extern "C" {
    pub fn SETLEVELS(x: SEXP, v: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_ENVFLAGS(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SET_FRAME(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_ENCLOS(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_HASHTAB(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_PRENV(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_PRVALUE(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn SET_PRCODE(x: SEXP, v: SEXP);
}
extern "C" {
    pub fn STDVEC_DATAPTR(x: SEXP) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn IS_GROWABLE(x: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn SET_GROWABLE_BIT(x: SEXP);
}
extern "C" {
    pub fn SET_NAMED(x: SEXP, v: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_tryWrap(arg1: SEXP) -> SEXP;
}
extern "C" {
    pub static mut R_Interactive: Rboolean;
}
extern "C" {
    pub static mut R_NoEcho: Rboolean;
}
extern "C" {
    pub fn R_RestoreGlobalEnv();
}
extern "C" {
    pub fn R_RestoreGlobalEnvFromFile(arg1: *const ::std::os::raw::c_char, arg2: Rboolean);
}
extern "C" {
    pub fn R_SaveGlobalEnv();
}
extern "C" {
    pub fn R_SaveGlobalEnvToFile(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn R_FlushConsole();
}
extern "C" {
    pub fn R_ClearerrConsole();
}
extern "C" {
    pub fn R_Suicide(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn R_HomeDir() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut R_DirtyImage: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut R_GUIType: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_setupHistory();
}
extern "C" {
    pub static mut R_HistoryFile: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub static mut R_HistorySize: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut R_RestoreHistory: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut R_Home: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_jump_to_toplevel();
}
extern "C" {
    pub fn Rf_mainloop();
}
extern "C" {
    pub fn Rf_onintr();
}
extern "C" {
    pub fn Rf_onintrNoResume();
}
extern "C" {
    pub static mut R_GlobalContext: *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn process_site_Renviron();
}
extern "C" {
    pub fn process_system_Renviron();
}
extern "C" {
    pub fn process_user_Renviron();
}
extern "C" {
    pub static mut R_Consolefile: *mut FILE;
}
extern "C" {
    pub static mut R_Outputfile: *mut FILE;
}
extern "C" {
    pub fn R_setStartTime();
}
extern "C" {
    pub fn fpu_setup(arg1: Rboolean);
}
extern "C" {
    pub static mut R_running_as_main_program: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut R_CStackLimit: usize;
}
extern "C" {
    pub static mut R_CStackStart: usize;
}
pub const SA_TYPE_SA_NORESTORE: SA_TYPE = 0;
pub const SA_TYPE_SA_RESTORE: SA_TYPE = 1;
pub const SA_TYPE_SA_DEFAULT: SA_TYPE = 2;
pub const SA_TYPE_SA_NOSAVE: SA_TYPE = 3;
pub const SA_TYPE_SA_SAVE: SA_TYPE = 4;
pub const SA_TYPE_SA_SAVEASK: SA_TYPE = 5;
pub const SA_TYPE_SA_SUICIDE: SA_TYPE = 6;
pub type SA_TYPE = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct structRstart {
    pub R_Quiet: Rboolean,
    pub R_NoEcho: Rboolean,
    pub R_Interactive: Rboolean,
    pub R_Verbose: Rboolean,
    pub LoadSiteFile: Rboolean,
    pub LoadInitFile: Rboolean,
    pub DebugInitFile: Rboolean,
    pub RestoreAction: SA_TYPE,
    pub SaveAction: SA_TYPE,
    pub vsize: usize,
    pub nsize: usize,
    pub max_vsize: usize,
    pub max_nsize: usize,
    pub ppsize: usize,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout_structRstart() {
    const UNINIT: ::std::mem::MaybeUninit<structRstart> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<structRstart>(),
        88usize,
        concat!("Size of: ", stringify!(structRstart))
    );
    assert_eq!(
        ::std::mem::align_of::<structRstart>(),
        8usize,
        concat!("Alignment of ", stringify!(structRstart))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).R_Quiet) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(R_Quiet)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).R_NoEcho) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(R_NoEcho)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).R_Interactive) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(R_Interactive)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).R_Verbose) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(R_Verbose)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).LoadSiteFile) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(LoadSiteFile)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).LoadInitFile) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(LoadInitFile)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).DebugInitFile) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(DebugInitFile)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).RestoreAction) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(RestoreAction)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).SaveAction) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(SaveAction)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vsize) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(vsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nsize) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(nsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_vsize) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(max_vsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_nsize) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(max_nsize)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ppsize) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(structRstart),
            "::",
            stringify!(ppsize)
        )
    );
}
impl structRstart {
    #[inline]
    pub fn NoRenviron(&self) -> Rboolean {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_NoRenviron(&mut self, val: Rboolean) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn RstartVersion(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_RstartVersion(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        NoRenviron: Rboolean,
        RstartVersion: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 16u8, {
            let NoRenviron: u32 = unsafe { ::std::mem::transmute(NoRenviron) };
            NoRenviron as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let RstartVersion: u32 = unsafe { ::std::mem::transmute(RstartVersion) };
            RstartVersion as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type Rstart = *mut structRstart;
extern "C" {
    pub fn R_DefParams(arg1: Rstart);
}
extern "C" {
    pub fn R_DefParamsEx(arg1: Rstart, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_SetParams(arg1: Rstart);
}
extern "C" {
    pub fn R_DefCallbacks(arg1: Rstart, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn R_SetWin32(arg1: Rstart);
}
extern "C" {
    pub fn R_SizeFromEnv(arg1: Rstart);
}
extern "C" {
    pub fn R_common_command_line(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: Rstart,
    );
}
extern "C" {
    pub fn R_set_command_line_arguments(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn setup_Rmainloop();
}
extern "C" {
    pub static mut ptr_R_Suicide:
        ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char)>;
}
extern "C" {
    pub static mut ptr_R_ShowMessage:
        ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char)>;
}
extern "C" {
    pub static mut ptr_R_ReadConsole: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: *mut ::std::os::raw::c_uchar,
            arg3: ::std::os::raw::c_int,
            arg4: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >;
}
extern "C" {
    pub static mut ptr_R_WriteConsole: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char, arg2: ::std::os::raw::c_int),
    >;
}
extern "C" {
    pub static mut ptr_R_WriteConsoleEx: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *const ::std::os::raw::c_char,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
        ),
    >;
}
extern "C" {
    pub static mut ptr_R_ResetConsole: ::std::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub static mut ptr_R_FlushConsole: ::std::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub static mut ptr_R_ClearerrConsole: ::std::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub static mut ptr_R_Busy:
        ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
}
extern "C" {
    pub static mut ptr_R_CleanUp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: SA_TYPE,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
        ),
    >;
}
extern "C" {
    pub static mut ptr_R_ShowFiles: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut *const ::std::os::raw::c_char,
            arg3: *mut *const ::std::os::raw::c_char,
            arg4: *const ::std::os::raw::c_char,
            arg5: Rboolean,
            arg6: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >;
}
extern "C" {
    pub static mut ptr_R_ChooseFile: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >;
}
extern "C" {
    pub static mut ptr_R_EditFile: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
    >;
}
extern "C" {
    pub static mut ptr_R_loadhistory:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP)>;
}
extern "C" {
    pub static mut ptr_R_savehistory:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP)>;
}
extern "C" {
    pub static mut ptr_R_addhistory:
        ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP)>;
}
extern "C" {
    pub static mut ptr_R_EditFiles: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut *const ::std::os::raw::c_char,
            arg3: *mut *const ::std::os::raw::c_char,
            arg4: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >;
}
extern "C" {
    pub static mut ptr_do_selectlist: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP,
    >;
}
extern "C" {
    pub static mut ptr_do_dataentry: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP,
    >;
}
extern "C" {
    pub static mut ptr_do_dataviewer: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP, arg4: SEXP) -> SEXP,
    >;
}
extern "C" {
    pub static mut ptr_R_ProcessEvents: ::std::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub static mut R_timeout_handler:
        ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>;
}
extern "C" {
    pub static mut R_timeout_val: ::std::os::raw::c_long;
}
extern "C" {
    pub static mut R_SignalHandlers: ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_initEmbeddedR(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_endEmbeddedR(fatal: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_initialize_R(
        ac: ::std::os::raw::c_int,
        av: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_ReplDLLinit();
}
extern "C" {
    pub fn R_ReplDLLdo1() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CleanEd();
}
extern "C" {
    pub fn Rf_KillAllDevices();
}
extern "C" {
    pub fn R_CleanTempDir();
}
extern "C" {
    pub static mut R_TempDir: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_pow(x: f64, y: f64) -> f64;
}
extern "C" {
    pub fn R_pow_di(arg1: f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn norm_rand() -> f64;
}
extern "C" {
    pub fn unif_rand() -> f64;
}
extern "C" {
    pub fn R_unif_index(arg1: f64) -> f64;
}
extern "C" {
    pub fn exp_rand() -> f64;
}
extern "C" {
    pub fn Rf_dnorm4(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnorm5(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnorm5(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rnorm(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_pnorm_both(
        arg1: f64,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_dunif(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_punif(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qunif(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_runif(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dgamma(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pgamma(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qgamma(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rgamma(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_log1pmx(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_log1pexp(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_log1mexp(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_lgamma1p(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_logspace_add(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_logspace_sub(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_logspace_sum(arg1: *const f64, arg2: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_dbeta(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rbeta(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dlnorm(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_plnorm(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qlnorm(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rlnorm(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dchisq(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pchisq(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qchisq(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rchisq(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_dnchisq(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnchisq(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnchisq(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rnchisq(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_df(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rf(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dt(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pt(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qt(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rt(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_dbinom_raw(x: f64, n: f64, p: f64, q: f64, give_log: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_dbinom(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rbinom(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_rmultinom(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_dcauchy(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pcauchy(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qcauchy(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rcauchy(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dexp(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pexp(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qexp(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rexp(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_dgeom(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pgeom(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qgeom(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rgeom(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_dhyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_phyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qhyper(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rhyper(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn Rf_dnbinom(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnbinom(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rnbinom(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dnbinom_mu(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnbinom_mu(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnbinom_mu(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rnbinom_mu(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dpois_raw(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_dpois(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_ppois(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qpois(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rpois(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_dweibull(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pweibull(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qweibull(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rweibull(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dlogis(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_plogis(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qlogis(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rlogis(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_dnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_pnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnbeta(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rnbeta(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn Rf_dnf(arg1: f64, arg2: f64, arg3: f64, arg4: f64, arg5: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnf(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_dnt(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pnt(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qnt(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_ptukey(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qtukey(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: f64,
        arg5: ::std::os::raw::c_int,
        arg6: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_dwilcox(arg1: f64, arg2: f64, arg3: f64, arg4: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_pwilcox(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qwilcox(
        arg1: f64,
        arg2: f64,
        arg3: f64,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rwilcox(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn wilcox_free();
}
extern "C" {
    pub fn Rf_dsignrank(arg1: f64, arg2: f64, arg3: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_psignrank(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_qsignrank(
        arg1: f64,
        arg2: f64,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn Rf_rsignrank(arg1: f64) -> f64;
}
extern "C" {
    pub fn signrank_free();
}
extern "C" {
    pub fn Rf_gammafn(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_lgammafn(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_lgammafn_sign(arg1: f64, arg2: *mut ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn Rf_dpsifn(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: *mut f64,
        arg6: *mut ::std::os::raw::c_int,
        arg7: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn Rf_psigamma(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_digamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_trigamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_tetragamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_pentagamma(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_beta(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_lbeta(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_choose(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_lchoose(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_i(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_j(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_k(arg1: f64, arg2: f64, arg3: f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_y(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_i_ex(arg1: f64, arg2: f64, arg3: f64, arg4: *mut f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_j_ex(arg1: f64, arg2: f64, arg3: *mut f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_k_ex(arg1: f64, arg2: f64, arg3: f64, arg4: *mut f64) -> f64;
}
extern "C" {
    pub fn Rf_bessel_y_ex(arg1: f64, arg2: f64, arg3: *mut f64) -> f64;
}
extern "C" {
    pub fn Rf_imax2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_imin2(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_fmax2(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_fmin2(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_sign(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rf_fprec(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_fround(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_fsign(arg1: f64, arg2: f64) -> f64;
}
extern "C" {
    pub fn Rf_ftrunc(arg1: f64) -> f64;
}
extern "C" {
    pub fn cospi(arg1: f64) -> f64;
}
extern "C" {
    pub fn sinpi(arg1: f64) -> f64;
}
extern "C" {
    pub fn tanpi(arg1: f64) -> f64;
}
extern "C" {
    pub fn Rtanpi(arg1: f64) -> f64;
}
pub const ParseStatus_PARSE_NULL: ParseStatus = 0;
pub const ParseStatus_PARSE_OK: ParseStatus = 1;
pub const ParseStatus_PARSE_INCOMPLETE: ParseStatus = 2;
pub const ParseStatus_PARSE_ERROR: ParseStatus = 3;
pub const ParseStatus_PARSE_EOF: ParseStatus = 4;
pub type ParseStatus = ::std::os::raw::c_uint;
extern "C" {
    pub fn R_ParseVector(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ParseStatus,
        arg4: SEXP,
    ) -> SEXP;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_altrep_class_t {
    pub ptr: SEXP,
}
#[test]
fn bindgen_test_layout_R_altrep_class_t() {
    const UNINIT: ::std::mem::MaybeUninit<R_altrep_class_t> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_altrep_class_t>(),
        8usize,
        concat!("Size of: ", stringify!(R_altrep_class_t))
    );
    assert_eq!(
        ::std::mem::align_of::<R_altrep_class_t>(),
        8usize,
        concat!("Alignment of ", stringify!(R_altrep_class_t))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_altrep_class_t),
            "::",
            stringify!(ptr)
        )
    );
}
extern "C" {
    pub fn R_new_altrep(aclass: R_altrep_class_t, data1: SEXP, data2: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_make_altstring_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altinteger_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altreal_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altlogical_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altraw_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_make_altcomplex_class(
        cname: *const ::std::os::raw::c_char,
        pname: *const ::std::os::raw::c_char,
        info: *mut DllInfo,
    ) -> R_altrep_class_t;
}
extern "C" {
    pub fn R_altrep_inherits(x: SEXP, arg1: R_altrep_class_t) -> Rboolean;
}
pub type R_altrep_UnserializeEX_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: SEXP,
        arg3: SEXP,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::os::raw::c_int,
    ) -> SEXP,
>;
pub type R_altrep_Unserialize_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP) -> SEXP>;
pub type R_altrep_Serialized_state_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> SEXP>;
pub type R_altrep_DuplicateEX_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Duplicate_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altrep_Coerce_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: ::std::os::raw::c_int) -> SEXP>;
pub type R_altrep_Inspect_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: ::std::os::raw::c_int,
        arg5: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: SEXP,
                arg2: ::std::os::raw::c_int,
                arg3: ::std::os::raw::c_int,
                arg4: ::std::os::raw::c_int,
            ),
        >,
    ) -> Rboolean,
>;
pub type R_altrep_Length_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> R_xlen_t>;
pub type R_altvec_Dataptr_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> *mut ::std::os::raw::c_void,
>;
pub type R_altvec_Dataptr_or_null_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> *const ::std::os::raw::c_void>;
pub type R_altvec_Extract_subset_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: SEXP, arg3: SEXP) -> SEXP>;
pub type R_altinteger_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altinteger_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altinteger_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altinteger_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altinteger_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> f64>;
pub type R_altreal_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut f64) -> R_xlen_t,
>;
pub type R_altreal_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altreal_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Min_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altreal_Max_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altlogical_Elt_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> ::std::os::raw::c_int,
>;
pub type R_altlogical_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut ::std::os::raw::c_int,
    ) -> R_xlen_t,
>;
pub type R_altlogical_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altlogical_Sum_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: Rboolean) -> SEXP>;
pub type R_altraw_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rbyte>;
pub type R_altraw_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: R_xlen_t, arg4: *mut Rbyte) -> R_xlen_t,
>;
pub type R_altcomplex_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> Rcomplex>;
pub type R_altcomplex_Get_region_method_t = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: SEXP,
        arg2: R_xlen_t,
        arg3: R_xlen_t,
        arg4: *mut Rcomplex,
    ) -> R_xlen_t,
>;
pub type R_altstring_Elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t) -> SEXP>;
pub type R_altstring_Set_elt_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP, arg2: R_xlen_t, arg3: SEXP)>;
pub type R_altstring_Is_sorted_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
pub type R_altstring_No_NA_method_t =
    ::std::option::Option<unsafe extern "C" fn(arg1: SEXP) -> ::std::os::raw::c_int>;
extern "C" {
    pub fn R_set_altrep_UnserializeEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_UnserializeEX_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Unserialize_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Unserialize_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Serialized_state_method(
        cls: R_altrep_class_t,
        fun: R_altrep_Serialized_state_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_DuplicateEX_method(
        cls: R_altrep_class_t,
        fun: R_altrep_DuplicateEX_method_t,
    );
}
extern "C" {
    pub fn R_set_altrep_Duplicate_method(cls: R_altrep_class_t, fun: R_altrep_Duplicate_method_t);
}
extern "C" {
    pub fn R_set_altrep_Coerce_method(cls: R_altrep_class_t, fun: R_altrep_Coerce_method_t);
}
extern "C" {
    pub fn R_set_altrep_Inspect_method(cls: R_altrep_class_t, fun: R_altrep_Inspect_method_t);
}
extern "C" {
    pub fn R_set_altrep_Length_method(cls: R_altrep_class_t, fun: R_altrep_Length_method_t);
}
extern "C" {
    pub fn R_set_altvec_Dataptr_method(cls: R_altrep_class_t, fun: R_altvec_Dataptr_method_t);
}
extern "C" {
    pub fn R_set_altvec_Dataptr_or_null_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Dataptr_or_null_method_t,
    );
}
extern "C" {
    pub fn R_set_altvec_Extract_subset_method(
        cls: R_altrep_class_t,
        fun: R_altvec_Extract_subset_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_Elt_method(cls: R_altrep_class_t, fun: R_altinteger_Elt_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altinteger_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altinteger_No_NA_method(cls: R_altrep_class_t, fun: R_altinteger_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Sum_method(cls: R_altrep_class_t, fun: R_altinteger_Sum_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Min_method(cls: R_altrep_class_t, fun: R_altinteger_Min_method_t);
}
extern "C" {
    pub fn R_set_altinteger_Max_method(cls: R_altrep_class_t, fun: R_altinteger_Max_method_t);
}
extern "C" {
    pub fn R_set_altreal_Elt_method(cls: R_altrep_class_t, fun: R_altreal_Elt_method_t);
}
extern "C" {
    pub fn R_set_altreal_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altreal_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altreal_Is_sorted_method(cls: R_altrep_class_t, fun: R_altreal_Is_sorted_method_t);
}
extern "C" {
    pub fn R_set_altreal_No_NA_method(cls: R_altrep_class_t, fun: R_altreal_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altreal_Sum_method(cls: R_altrep_class_t, fun: R_altreal_Sum_method_t);
}
extern "C" {
    pub fn R_set_altreal_Min_method(cls: R_altrep_class_t, fun: R_altreal_Min_method_t);
}
extern "C" {
    pub fn R_set_altreal_Max_method(cls: R_altrep_class_t, fun: R_altreal_Max_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Elt_method(cls: R_altrep_class_t, fun: R_altlogical_Elt_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altlogical_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altlogical_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altlogical_No_NA_method(cls: R_altrep_class_t, fun: R_altlogical_No_NA_method_t);
}
extern "C" {
    pub fn R_set_altlogical_Sum_method(cls: R_altrep_class_t, fun: R_altlogical_Sum_method_t);
}
extern "C" {
    pub fn R_set_altraw_Elt_method(cls: R_altrep_class_t, fun: R_altraw_Elt_method_t);
}
extern "C" {
    pub fn R_set_altraw_Get_region_method(cls: R_altrep_class_t, fun: R_altraw_Get_region_method_t);
}
extern "C" {
    pub fn R_set_altcomplex_Elt_method(cls: R_altrep_class_t, fun: R_altcomplex_Elt_method_t);
}
extern "C" {
    pub fn R_set_altcomplex_Get_region_method(
        cls: R_altrep_class_t,
        fun: R_altcomplex_Get_region_method_t,
    );
}
extern "C" {
    pub fn R_set_altstring_Elt_method(cls: R_altrep_class_t, fun: R_altstring_Elt_method_t);
}
extern "C" {
    pub fn R_set_altstring_Set_elt_method(cls: R_altrep_class_t, fun: R_altstring_Set_elt_method_t);
}
extern "C" {
    pub fn R_set_altstring_Is_sorted_method(
        cls: R_altrep_class_t,
        fun: R_altstring_Is_sorted_method_t,
    );
}
extern "C" {
    pub fn R_set_altstring_No_NA_method(cls: R_altrep_class_t, fun: R_altstring_No_NA_method_t);
}
extern "C" {
    pub fn R_GE_getVersion() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_checkVersionOrDie(version: ::std::os::raw::c_int);
}
pub const GEUnit_GE_DEVICE: GEUnit = 0;
pub const GEUnit_GE_NDC: GEUnit = 1;
pub const GEUnit_GE_INCHES: GEUnit = 2;
pub const GEUnit_GE_CM: GEUnit = 3;
pub type GEUnit = ::std::os::raw::c_uint;
pub const GEevent_GE_InitState: GEevent = 0;
pub const GEevent_GE_FinaliseState: GEevent = 1;
pub const GEevent_GE_SaveState: GEevent = 2;
pub const GEevent_GE_RestoreState: GEevent = 6;
pub const GEevent_GE_CopyState: GEevent = 3;
pub const GEevent_GE_SaveSnapshotState: GEevent = 4;
pub const GEevent_GE_RestoreSnapshotState: GEevent = 5;
pub const GEevent_GE_CheckPlot: GEevent = 7;
pub const GEevent_GE_ScalePS: GEevent = 8;
pub type GEevent = ::std::os::raw::c_uint;
pub const R_GE_lineend_GE_ROUND_CAP: R_GE_lineend = 1;
pub const R_GE_lineend_GE_BUTT_CAP: R_GE_lineend = 2;
pub const R_GE_lineend_GE_SQUARE_CAP: R_GE_lineend = 3;
pub type R_GE_lineend = ::std::os::raw::c_uint;
pub const R_GE_linejoin_GE_ROUND_JOIN: R_GE_linejoin = 1;
pub const R_GE_linejoin_GE_MITRE_JOIN: R_GE_linejoin = 2;
pub const R_GE_linejoin_GE_BEVEL_JOIN: R_GE_linejoin = 3;
pub type R_GE_linejoin = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct R_GE_gcontext {
    pub col: ::std::os::raw::c_int,
    pub fill: ::std::os::raw::c_int,
    pub gamma: f64,
    pub lwd: f64,
    pub lty: ::std::os::raw::c_int,
    pub lend: R_GE_lineend,
    pub ljoin: R_GE_linejoin,
    pub lmitre: f64,
    pub cex: f64,
    pub ps: f64,
    pub lineheight: f64,
    pub fontface: ::std::os::raw::c_int,
    pub fontfamily: [::std::os::raw::c_char; 201usize],
    pub patternFill: SEXP,
}
#[test]
fn bindgen_test_layout_R_GE_gcontext() {
    const UNINIT: ::std::mem::MaybeUninit<R_GE_gcontext> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<R_GE_gcontext>(),
        288usize,
        concat!("Size of: ", stringify!(R_GE_gcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<R_GE_gcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(R_GE_gcontext))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).col) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(col)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fill) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fill)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gamma) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(gamma)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lwd) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lwd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lty) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lty)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lend) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lend)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ljoin) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(ljoin)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lmitre) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lmitre)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cex) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(cex)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ps) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(ps)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lineheight) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(lineheight)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fontface) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fontface)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fontfamily) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(fontfamily)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).patternFill) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(R_GE_gcontext),
            "::",
            stringify!(patternFill)
        )
    );
}
pub type pGEcontext = *mut R_GE_gcontext;
pub type DevDesc = _DevDesc;
pub type pDevDesc = *mut DevDesc;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _DevDesc {
    #[doc = " Device physical characteristics"]
    pub left: f64,
    pub right: f64,
    pub bottom: f64,
    pub top: f64,
    pub clipLeft: f64,
    pub clipRight: f64,
    pub clipBottom: f64,
    pub clipTop: f64,
    pub xCharOffset: f64,
    pub yCharOffset: f64,
    pub yLineBias: f64,
    pub ipr: [f64; 2usize],
    pub cra: [f64; 2usize],
    pub gamma: f64,
    #[doc = " Device capabilities"]
    pub canClip: Rboolean,
    pub canChangeGamma: Rboolean,
    pub canHAdj: ::std::os::raw::c_int,
    #[doc = " Device initial settings"]
    pub startps: f64,
    pub startcol: ::std::os::raw::c_int,
    pub startfill: ::std::os::raw::c_int,
    pub startlty: ::std::os::raw::c_int,
    pub startfont: ::std::os::raw::c_int,
    pub startgamma: f64,
    #[doc = " Device specific information"]
    pub deviceSpecific: *mut ::std::os::raw::c_void,
    #[doc = " Device display list"]
    pub displayListOn: Rboolean,
    #[doc = " Event handling entries"]
    pub canGenMouseDown: Rboolean,
    pub canGenMouseMove: Rboolean,
    pub canGenMouseUp: Rboolean,
    pub canGenKeybd: Rboolean,
    pub canGenIdle: Rboolean,
    pub gettingEvent: Rboolean,
    pub activate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub circle: ::std::option::Option<
        unsafe extern "C" fn(x: f64, y: f64, r: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub clip: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, x1: f64, y0: f64, y1: f64, dd: pDevDesc),
    >,
    pub close: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    pub deactivate: ::std::option::Option<unsafe extern "C" fn(arg1: pDevDesc)>,
    pub locator: ::std::option::Option<
        unsafe extern "C" fn(x: *mut f64, y: *mut f64, dd: pDevDesc) -> Rboolean,
    >,
    pub line: ::std::option::Option<
        unsafe extern "C" fn(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub metricInfo: ::std::option::Option<
        unsafe extern "C" fn(
            c: ::std::os::raw::c_int,
            gc: pGEcontext,
            ascent: *mut f64,
            descent: *mut f64,
            width: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub mode:
        ::std::option::Option<unsafe extern "C" fn(mode: ::std::os::raw::c_int, dd: pDevDesc)>,
    pub newPage: ::std::option::Option<unsafe extern "C" fn(gc: pGEcontext, dd: pDevDesc)>,
    pub polygon: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub polyline: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub rect: ::std::option::Option<
        unsafe extern "C" fn(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pDevDesc),
    >,
    pub path: ::std::option::Option<
        unsafe extern "C" fn(
            x: *mut f64,
            y: *mut f64,
            npoly: ::std::os::raw::c_int,
            nper: *mut ::std::os::raw::c_int,
            winding: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub raster: ::std::option::Option<
        unsafe extern "C" fn(
            raster: *mut ::std::os::raw::c_uint,
            w: ::std::os::raw::c_int,
            h: ::std::os::raw::c_int,
            x: f64,
            y: f64,
            width: f64,
            height: f64,
            rot: f64,
            interpolate: Rboolean,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub cap: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> SEXP>,
    pub size: ::std::option::Option<
        unsafe extern "C" fn(
            left: *mut f64,
            right: *mut f64,
            bottom: *mut f64,
            top: *mut f64,
            dd: pDevDesc,
        ),
    >,
    pub strWidth: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub text: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str_: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub onExit: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc)>,
    pub getEvent: ::std::option::Option<
        unsafe extern "C" fn(arg1: SEXP, arg2: *const ::std::os::raw::c_char) -> SEXP,
    >,
    pub newFrameConfirm: ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc) -> Rboolean>,
    pub hasTextUTF8: Rboolean,
    pub textUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            x: f64,
            y: f64,
            str_: *const ::std::os::raw::c_char,
            rot: f64,
            hadj: f64,
            gc: pGEcontext,
            dd: pDevDesc,
        ),
    >,
    pub strWidthUTF8: ::std::option::Option<
        unsafe extern "C" fn(
            str_: *const ::std::os::raw::c_char,
            gc: pGEcontext,
            dd: pDevDesc,
        ) -> f64,
    >,
    pub wantSymbolUTF8: Rboolean,
    pub useRotatedTextInContour: Rboolean,
    pub eventEnv: SEXP,
    pub eventHelper:
        ::std::option::Option<unsafe extern "C" fn(dd: pDevDesc, code: ::std::os::raw::c_int)>,
    pub holdflush: ::std::option::Option<
        unsafe extern "C" fn(dd: pDevDesc, level: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
    >,
    pub haveTransparency: ::std::os::raw::c_int,
    pub haveTransparentBg: ::std::os::raw::c_int,
    pub haveRaster: ::std::os::raw::c_int,
    pub haveCapture: ::std::os::raw::c_int,
    pub haveLocator: ::std::os::raw::c_int,
    pub setPattern:
        ::std::option::Option<unsafe extern "C" fn(pattern: SEXP, dd: pDevDesc) -> SEXP>,
    pub releasePattern: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub setClipPath:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, ref_: SEXP, dd: pDevDesc) -> SEXP>,
    pub releaseClipPath: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub setMask:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, ref_: SEXP, dd: pDevDesc) -> SEXP>,
    pub releaseMask: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub deviceVersion: ::std::os::raw::c_int,
    pub deviceClip: Rboolean,
    pub defineGroup: ::std::option::Option<
        unsafe extern "C" fn(
            source: SEXP,
            op: ::std::os::raw::c_int,
            destination: SEXP,
            dd: pDevDesc,
        ) -> SEXP,
    >,
    pub useGroup:
        ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, trans: SEXP, dd: pDevDesc)>,
    pub releaseGroup: ::std::option::Option<unsafe extern "C" fn(ref_: SEXP, dd: pDevDesc)>,
    pub stroke:
        ::std::option::Option<unsafe extern "C" fn(path: SEXP, gc: pGEcontext, dd: pDevDesc)>,
    pub fill: ::std::option::Option<
        unsafe extern "C" fn(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pDevDesc),
    >,
    pub fillStroke: ::std::option::Option<
        unsafe extern "C" fn(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pDevDesc),
    >,
    pub capabilities: ::std::option::Option<unsafe extern "C" fn(cap: SEXP) -> SEXP>,
    pub glyph: ::std::option::Option<
        unsafe extern "C" fn(
            n: ::std::os::raw::c_int,
            glyphs: *mut ::std::os::raw::c_int,
            x: *mut f64,
            y: *mut f64,
            font: SEXP,
            size: f64,
            colour: ::std::os::raw::c_int,
            rot: f64,
            dd: pDevDesc,
        ),
    >,
    pub reserved: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout__DevDesc() {
    const UNINIT: ::std::mem::MaybeUninit<_DevDesc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_DevDesc>(),
        656usize,
        concat!("Size of: ", stringify!(_DevDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<_DevDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(_DevDesc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).left) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(left)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).right) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(right)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bottom) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(bottom)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).top) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(top)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clipLeft) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipLeft)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clipRight) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipRight)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clipBottom) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipBottom)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clipTop) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clipTop)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).xCharOffset) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(xCharOffset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).yCharOffset) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(yCharOffset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).yLineBias) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(yLineBias)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ipr) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(ipr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cra) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(cra)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gamma) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(gamma)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canClip) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canClip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canChangeGamma) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canChangeGamma)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canHAdj) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canHAdj)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startps) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startps)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startcol) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startcol)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startfill) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startfill)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startlty) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startlty)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startfont) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startfont)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).startgamma) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(startgamma)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deviceSpecific) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deviceSpecific)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).displayListOn) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(displayListOn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canGenMouseDown) as usize - ptr as usize },
        188usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseDown)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canGenMouseMove) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseMove)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canGenMouseUp) as usize - ptr as usize },
        196usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenMouseUp)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canGenKeybd) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenKeybd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).canGenIdle) as usize - ptr as usize },
        204usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(canGenIdle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gettingEvent) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(gettingEvent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).activate) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(activate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).circle) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(circle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).clip) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(clip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).close) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(close)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deactivate) as usize - ptr as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deactivate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).locator) as usize - ptr as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(locator)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).line) as usize - ptr as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(line)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metricInfo) as usize - ptr as usize },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(metricInfo)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mode) as usize - ptr as usize },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(mode)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).newPage) as usize - ptr as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(newPage)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).polygon) as usize - ptr as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(polygon)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).polyline) as usize - ptr as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(polyline)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rect) as usize - ptr as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(rect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).path) as usize - ptr as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(path)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).raster) as usize - ptr as usize },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(raster)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap) as usize - ptr as usize },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(cap)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).strWidth) as usize - ptr as usize },
        352usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(strWidth)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).text) as usize - ptr as usize },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onExit) as usize - ptr as usize },
        368usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(onExit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).getEvent) as usize - ptr as usize },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(getEvent)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).newFrameConfirm) as usize - ptr as usize },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(newFrameConfirm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hasTextUTF8) as usize - ptr as usize },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(hasTextUTF8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).textUTF8) as usize - ptr as usize },
        400usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(textUTF8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).strWidthUTF8) as usize - ptr as usize },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(strWidthUTF8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).wantSymbolUTF8) as usize - ptr as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(wantSymbolUTF8)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).useRotatedTextInContour) as usize - ptr as usize },
        420usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(useRotatedTextInContour)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eventEnv) as usize - ptr as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(eventEnv)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eventHelper) as usize - ptr as usize },
        432usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(eventHelper)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).holdflush) as usize - ptr as usize },
        440usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(holdflush)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).haveTransparency) as usize - ptr as usize },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveTransparency)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).haveTransparentBg) as usize - ptr as usize },
        452usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveTransparentBg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).haveRaster) as usize - ptr as usize },
        456usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveRaster)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).haveCapture) as usize - ptr as usize },
        460usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveCapture)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).haveLocator) as usize - ptr as usize },
        464usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(haveLocator)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).setPattern) as usize - ptr as usize },
        472usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(setPattern)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).releasePattern) as usize - ptr as usize },
        480usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(releasePattern)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).setClipPath) as usize - ptr as usize },
        488usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(setClipPath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).releaseClipPath) as usize - ptr as usize },
        496usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(releaseClipPath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).setMask) as usize - ptr as usize },
        504usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(setMask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).releaseMask) as usize - ptr as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(releaseMask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deviceVersion) as usize - ptr as usize },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deviceVersion)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deviceClip) as usize - ptr as usize },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(deviceClip)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).defineGroup) as usize - ptr as usize },
        528usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(defineGroup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).useGroup) as usize - ptr as usize },
        536usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(useGroup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).releaseGroup) as usize - ptr as usize },
        544usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(releaseGroup)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stroke) as usize - ptr as usize },
        552usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(stroke)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fill) as usize - ptr as usize },
        560usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(fill)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fillStroke) as usize - ptr as usize },
        568usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(fillStroke)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).capabilities) as usize - ptr as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(capabilities)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).glyph) as usize - ptr as usize },
        584usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(glyph)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reserved) as usize - ptr as usize },
        592usize,
        concat!(
            "Offset of field: ",
            stringify!(_DevDesc),
            "::",
            stringify!(reserved)
        )
    );
}
extern "C" {
    pub fn Rf_ndevNumber(arg1: pDevDesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_NumDevices() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_CheckDeviceAvailable();
}
extern "C" {
    pub fn R_CheckDeviceAvailableBool() -> Rboolean;
}
extern "C" {
    pub fn Rf_curDevice() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_nextDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_prevDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_selectDevice(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_killDevice(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn Rf_NoDevices() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_NewFrameConfirm(arg1: pDevDesc);
}
pub const R_KeyName_knUNKNOWN: R_KeyName = -1;
pub const R_KeyName_knLEFT: R_KeyName = 0;
pub const R_KeyName_knUP: R_KeyName = 1;
pub const R_KeyName_knRIGHT: R_KeyName = 2;
pub const R_KeyName_knDOWN: R_KeyName = 3;
pub const R_KeyName_knF1: R_KeyName = 4;
pub const R_KeyName_knF2: R_KeyName = 5;
pub const R_KeyName_knF3: R_KeyName = 6;
pub const R_KeyName_knF4: R_KeyName = 7;
pub const R_KeyName_knF5: R_KeyName = 8;
pub const R_KeyName_knF6: R_KeyName = 9;
pub const R_KeyName_knF7: R_KeyName = 10;
pub const R_KeyName_knF8: R_KeyName = 11;
pub const R_KeyName_knF9: R_KeyName = 12;
pub const R_KeyName_knF10: R_KeyName = 13;
pub const R_KeyName_knF11: R_KeyName = 14;
pub const R_KeyName_knF12: R_KeyName = 15;
pub const R_KeyName_knPGUP: R_KeyName = 16;
pub const R_KeyName_knPGDN: R_KeyName = 17;
pub const R_KeyName_knEND: R_KeyName = 18;
pub const R_KeyName_knHOME: R_KeyName = 19;
pub const R_KeyName_knINS: R_KeyName = 20;
pub const R_KeyName_knDEL: R_KeyName = 21;
pub type R_KeyName = ::std::os::raw::c_int;
pub const R_MouseEvent_meMouseDown: R_MouseEvent = 0;
pub const R_MouseEvent_meMouseUp: R_MouseEvent = 1;
pub const R_MouseEvent_meMouseMove: R_MouseEvent = 2;
pub type R_MouseEvent = ::std::os::raw::c_uint;
extern "C" {
    pub fn Rf_doMouseEvent(
        dd: pDevDesc,
        event: R_MouseEvent,
        buttons: ::std::os::raw::c_int,
        x: f64,
        y: f64,
    );
}
extern "C" {
    pub fn Rf_doKeybd(dd: pDevDesc, rkey: R_KeyName, keyname: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn Rf_doIdle(dd: pDevDesc);
}
extern "C" {
    pub fn Rf_doesIdle(dd: pDevDesc) -> Rboolean;
}
extern "C" {
    pub static mut R_interrupts_suspended: Rboolean;
}
extern "C" {
    pub static mut R_interrupts_pending: ::std::os::raw::c_int;
}
extern "C" {
    pub static mut mbcslocale: Rboolean;
}
extern "C" {
    pub fn Rf_AdobeSymbol2utf8(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
        nwork: usize,
        usePUA: Rboolean,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn Rf_utf8toAdobeSymbol(
        out: *mut ::std::os::raw::c_char,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn Rf_utf8Toutf8NoPUA(in_: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_utf8ToLatin1AdobeSymbol2utf8(
        in_: *const ::std::os::raw::c_char,
        usePUA: Rboolean,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn Rf_ucstoutf8(s: *mut ::std::os::raw::c_char, c: ::std::os::raw::c_uint) -> usize;
}
pub type GEDevDesc = _GEDevDesc;
pub type GEcallback = ::std::option::Option<
    unsafe extern "C" fn(arg1: GEevent, arg2: *mut GEDevDesc, arg3: SEXP) -> SEXP,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GESystemDesc {
    pub systemSpecific: *mut ::std::os::raw::c_void,
    pub callback: GEcallback,
}
#[test]
fn bindgen_test_layout_GESystemDesc() {
    const UNINIT: ::std::mem::MaybeUninit<GESystemDesc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GESystemDesc>(),
        16usize,
        concat!("Size of: ", stringify!(GESystemDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<GESystemDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(GESystemDesc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).systemSpecific) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(GESystemDesc),
            "::",
            stringify!(systemSpecific)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(GESystemDesc),
            "::",
            stringify!(callback)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _GEDevDesc {
    pub dev: pDevDesc,
    pub displayListOn: Rboolean,
    pub displayList: SEXP,
    pub DLlastElt: SEXP,
    pub savedSnapshot: SEXP,
    pub dirty: Rboolean,
    pub recordGraphics: Rboolean,
    pub gesd: [*mut GESystemDesc; 24usize],
    pub ask: Rboolean,
    pub appending: Rboolean,
}
#[test]
fn bindgen_test_layout__GEDevDesc() {
    const UNINIT: ::std::mem::MaybeUninit<_GEDevDesc> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_GEDevDesc>(),
        248usize,
        concat!("Size of: ", stringify!(_GEDevDesc))
    );
    assert_eq!(
        ::std::mem::align_of::<_GEDevDesc>(),
        8usize,
        concat!("Alignment of ", stringify!(_GEDevDesc))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(dev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).displayListOn) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(displayListOn)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).displayList) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(displayList)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).DLlastElt) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(DLlastElt)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).savedSnapshot) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(savedSnapshot)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirty) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(dirty)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recordGraphics) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(recordGraphics)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gesd) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(gesd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ask) as usize - ptr as usize },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(ask)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).appending) as usize - ptr as usize },
        244usize,
        concat!(
            "Offset of field: ",
            stringify!(_GEDevDesc),
            "::",
            stringify!(appending)
        )
    );
}
pub type pGEDevDesc = *mut GEDevDesc;
extern "C" {
    pub fn Rf_desc2GEDesc(dd: pDevDesc) -> pGEDevDesc;
}
extern "C" {
    pub fn GEdeviceNumber(arg1: pGEDevDesc) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GEgetDevice(arg1: ::std::os::raw::c_int) -> pGEDevDesc;
}
extern "C" {
    pub fn GEaddDevice(arg1: pGEDevDesc);
}
extern "C" {
    pub fn GEaddDevice2(arg1: pGEDevDesc, arg2: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn GEaddDevice2f(
        arg1: pGEDevDesc,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    );
}
extern "C" {
    pub fn GEkillDevice(arg1: pGEDevDesc);
}
extern "C" {
    pub fn GEcreateDevDesc(dev: pDevDesc) -> pGEDevDesc;
}
extern "C" {
    pub fn GEdestroyDevDesc(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEsystemState(
        dd: pGEDevDesc,
        index: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn GEregisterWithDevice(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEregisterSystem(callback: GEcallback, systemRegisterIndex: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEunregisterSystem(registerIndex: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEhandleEvent(event: GEevent, dev: pDevDesc, data: SEXP) -> SEXP;
}
extern "C" {
    pub fn GEfromDeviceX(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceX(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceY(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceY(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceWidth(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceWidth(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEfromDeviceHeight(value: f64, to: GEUnit, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEtoDeviceHeight(value: f64, from: GEUnit, dd: pGEDevDesc) -> f64;
}
pub type rcolor = ::std::os::raw::c_uint;
extern "C" {
    pub fn Rf_RGBpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> rcolor;
}
extern "C" {
    pub fn Rf_RGBpar3(arg1: SEXP, arg2: ::std::os::raw::c_int, arg3: rcolor) -> rcolor;
}
extern "C" {
    pub fn Rf_col2name(col: rcolor) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_GE_str2col(s: *const ::std::os::raw::c_char) -> rcolor;
}
extern "C" {
    pub fn GE_LENDpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_lineend;
}
extern "C" {
    pub fn GE_LENDget(lend: R_GE_lineend) -> SEXP;
}
extern "C" {
    pub fn GE_LJOINpar(value: SEXP, ind: ::std::os::raw::c_int) -> R_GE_linejoin;
}
extern "C" {
    pub fn GE_LJOINget(ljoin: R_GE_linejoin) -> SEXP;
}
extern "C" {
    pub fn GESetClip(x1: f64, y1: f64, x2: f64, y2: f64, dd: pGEDevDesc);
}
extern "C" {
    pub fn GENewPage(gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GELine(x1: f64, y1: f64, x2: f64, y2: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEPolyline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEPolygon(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEXspline(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        s: *mut f64,
        open: Rboolean,
        repEnds: Rboolean,
        draw: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> SEXP;
}
extern "C" {
    pub fn GECircle(x: f64, y: f64, radius: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GERect(x0: f64, y0: f64, x1: f64, y1: f64, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEPath(
        x: *mut f64,
        y: *mut f64,
        npoly: ::std::os::raw::c_int,
        nper: *mut ::std::os::raw::c_int,
        winding: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GERaster(
        raster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        x: f64,
        y: f64,
        width: f64,
        height: f64,
        angle: f64,
        interpolate: Rboolean,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GECap(dd: pGEDevDesc) -> SEXP;
}
extern "C" {
    pub fn GEText(
        x: f64,
        y: f64,
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEMode(mode: ::std::os::raw::c_int, dd: pGEDevDesc);
}
extern "C" {
    pub fn GESymbol(
        x: f64,
        y: f64,
        pch: ::std::os::raw::c_int,
        size: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEPretty(lo: *mut f64, up: *mut f64, ndiv: *mut ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEMetricInfo(
        c: ::std::os::raw::c_int,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEStrWidth(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn GEStrHeight(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn GEStrMetric(
        str_: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEstring_to_pch(pch: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GE_LTYpar(arg1: SEXP, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn GE_LTYget(arg1: ::std::os::raw::c_uint) -> SEXP;
}
extern "C" {
    pub fn R_GE_rasterScale(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterInterpolate(
        sraster: *mut ::std::os::raw::c_uint,
        sw: ::std::os::raw::c_int,
        sh: ::std::os::raw::c_int,
        draster: *mut ::std::os::raw::c_uint,
        dw: ::std::os::raw::c_int,
        dh: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterRotatedSize(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        wnew: *mut ::std::os::raw::c_int,
        hnew: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_rasterRotatedOffset(
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        botleft: ::std::os::raw::c_int,
        xoff: *mut f64,
        yoff: *mut f64,
    );
}
extern "C" {
    pub fn R_GE_rasterResizeForRotation(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        newRaster: *mut ::std::os::raw::c_uint,
        wnew: ::std::os::raw::c_int,
        hnew: ::std::os::raw::c_int,
        gc: pGEcontext,
    );
}
extern "C" {
    pub fn R_GE_rasterRotate(
        sraster: *mut ::std::os::raw::c_uint,
        w: ::std::os::raw::c_int,
        h: ::std::os::raw::c_int,
        angle: f64,
        draster: *mut ::std::os::raw::c_uint,
        gc: pGEcontext,
        perPixelAlpha: Rboolean,
    );
}
extern "C" {
    pub fn GEExpressionWidth(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEExpressionHeight(expr: SEXP, gc: pGEcontext, dd: pGEDevDesc) -> f64;
}
extern "C" {
    pub fn GEExpressionMetric(
        expr: SEXP,
        gc: pGEcontext,
        ascent: *mut f64,
        descent: *mut f64,
        width: *mut f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEMathText(
        x: f64,
        y: f64,
        expr: SEXP,
        xc: f64,
        yc: f64,
        rot: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEcontourLines(
        x: *mut f64,
        nx: ::std::os::raw::c_int,
        y: *mut f64,
        ny: ::std::os::raw::c_int,
        z: *mut f64,
        levels: *mut f64,
        nl: ::std::os::raw::c_int,
    ) -> SEXP;
}
extern "C" {
    pub fn R_GE_VStrWidth(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn R_GE_VStrHeight(
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        gc: pGEcontext,
        dd: pGEDevDesc,
    ) -> f64;
}
extern "C" {
    pub fn R_GE_VText(
        x: f64,
        y: f64,
        s: *const ::std::os::raw::c_char,
        enc: cetype_t,
        x_justify: f64,
        y_justify: f64,
        rotation: f64,
        gc: pGEcontext,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn GEcurrentDevice() -> pGEDevDesc;
}
extern "C" {
    pub fn GEdeviceDirty(dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GEdirtyDevice(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEcheckState(dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GErecording(call: SEXP, dd: pGEDevDesc) -> Rboolean;
}
extern "C" {
    pub fn GErecordGraphicOperation(op: SEXP, args: SEXP, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEinitDisplayList(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEplayDisplayList(dd: pGEDevDesc);
}
extern "C" {
    pub fn GEcopyDisplayList(fromDevice: ::std::os::raw::c_int);
}
extern "C" {
    pub fn GEcreateSnapshot(dd: pGEDevDesc) -> SEXP;
}
extern "C" {
    pub fn GEplaySnapshot(snapshot: SEXP, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEonExit();
}
extern "C" {
    pub fn GEnullDevice();
}
extern "C" {
    pub fn Rf_CreateAtVector(
        axp: *mut f64,
        usr: *const f64,
        nint: ::std::os::raw::c_int,
        logflag: Rboolean,
    ) -> SEXP;
}
extern "C" {
    pub fn Rf_GAxisPars(
        min: *mut f64,
        max: *mut f64,
        n: *mut ::std::os::raw::c_int,
        log: Rboolean,
        axis: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn R_GE_isPattern(x: SEXP) -> Rboolean;
}
extern "C" {
    pub fn R_GE_patternType(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_linearGradientX1(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_linearGradientY1(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_linearGradientX2(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_linearGradientY2(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_linearGradientNumStops(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_linearGradientStop(pattern: SEXP, i: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn R_GE_linearGradientColour(pattern: SEXP, i: ::std::os::raw::c_int) -> rcolor;
}
extern "C" {
    pub fn R_GE_linearGradientExtend(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_radialGradientCX1(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientCY1(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientR1(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientCX2(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientCY2(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientR2(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientNumStops(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_radialGradientStop(pattern: SEXP, i: ::std::os::raw::c_int) -> f64;
}
extern "C" {
    pub fn R_GE_radialGradientColour(pattern: SEXP, i: ::std::os::raw::c_int) -> rcolor;
}
extern "C" {
    pub fn R_GE_radialGradientExtend(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_tilingPatternFunction(pattern: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_tilingPatternX(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_tilingPatternY(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_tilingPatternWidth(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_tilingPatternHeight(pattern: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_tilingPatternExtend(pattern: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_clipPathFillRule(path: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn GEStroke(path: SEXP, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEFill(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn GEFillStroke(path: SEXP, rule: ::std::os::raw::c_int, gc: pGEcontext, dd: pGEDevDesc);
}
extern "C" {
    pub fn R_GE_maskType(mask: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_glyphInfoGlyphs(glyphInfo: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphInfoFonts(glyphInfo: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphID(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphX(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphY(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphFont(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphSize(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphColour(glyphs: SEXP) -> SEXP;
}
extern "C" {
    pub fn R_GE_glyphFontFile(glyphFont: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_GE_glyphFontIndex(glyphFont: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_glyphFontFamily(glyphFont: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn R_GE_glyphFontWeight(glyphFont: SEXP) -> f64;
}
extern "C" {
    pub fn R_GE_glyphFontStyle(glyphFont: SEXP) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn R_GE_glyphFontPSname(glyphFont: SEXP) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn GEGlyph(
        n: ::std::os::raw::c_int,
        glyphs: *mut ::std::os::raw::c_int,
        x: *mut f64,
        y: *mut f64,
        font: SEXP,
        size: f64,
        colour: ::std::os::raw::c_int,
        rot: f64,
        dd: pGEDevDesc,
    );
}
extern "C" {
    pub fn R_chk_calloc(arg1: usize, arg2: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_chk_realloc(
        arg1: *mut ::std::os::raw::c_void,
        arg2: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn R_chk_free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn dasum_(
        n: *const ::std::os::raw::c_int,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn daxpy_(
        n: *const ::std::os::raw::c_int,
        da: *const f64,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
        dy: *mut f64,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn dcopy_(
        n: *const ::std::os::raw::c_int,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
        dy: *mut f64,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn ddot_(
        n: *const ::std::os::raw::c_int,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
        dy: *const f64,
        incy: *const ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn dnrm2_(
        n: *const ::std::os::raw::c_int,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn drot_(
        n: *const ::std::os::raw::c_int,
        dx: *mut f64,
        incx: *const ::std::os::raw::c_int,
        dy: *mut f64,
        incy: *const ::std::os::raw::c_int,
        c: *const f64,
        s: *const f64,
    );
}
extern "C" {
    pub fn drotg_(a: *const f64, b: *const f64, c: *mut f64, s: *mut f64);
}
extern "C" {
    pub fn drotm_(
        n: *const ::std::os::raw::c_int,
        dx: *mut f64,
        incx: *const ::std::os::raw::c_int,
        dy: *mut f64,
        incy: *const ::std::os::raw::c_int,
        dparam: *const f64,
    );
}
extern "C" {
    pub fn drotmg_(
        dd1: *const f64,
        dd2: *const f64,
        dx1: *const f64,
        dy1: *const f64,
        param: *mut f64,
    );
}
extern "C" {
    pub fn dscal_(
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        dx: *mut f64,
        incx: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn dswap_(
        n: *const ::std::os::raw::c_int,
        dx: *mut f64,
        incx: *const ::std::os::raw::c_int,
        dy: *mut f64,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn idamax_(
        n: *const ::std::os::raw::c_int,
        dx: *const f64,
        incx: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn dgbmv_(
        trans: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        kl: *const ::std::os::raw::c_int,
        ku: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        y: *mut f64,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dgemv_(
        trans: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        y: *mut f64,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dsbmv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        y: *mut f64,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dspmv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        ap: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        y: *mut f64,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dsymv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        y: *mut f64,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dtbmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dtpmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        ap: *const f64,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dtrmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dtbsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dtpsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        ap: *const f64,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dtrsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        x: *mut f64,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn dger_(
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        y: *const f64,
        incy: *const ::std::os::raw::c_int,
        a: *mut f64,
        lda: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn dsyr_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        a: *mut f64,
        lda: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dspr_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        ap: *mut f64,
        arg1: usize,
    );
}
extern "C" {
    pub fn dsyr2_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        y: *const f64,
        incy: *const ::std::os::raw::c_int,
        a: *mut f64,
        lda: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn dspr2_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const f64,
        incx: *const ::std::os::raw::c_int,
        y: *const f64,
        incy: *const ::std::os::raw::c_int,
        ap: *mut f64,
        arg1: usize,
    );
}
extern "C" {
    pub fn dgemm_(
        transa: *const ::std::os::raw::c_char,
        transb: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        b: *const f64,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut f64,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn dtrsm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        transa: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        b: *mut f64,
        ldb: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
        arg4: usize,
    );
}
extern "C" {
    pub fn dtrmm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        transa: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        b: *mut f64,
        ldb: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
        arg4: usize,
    );
}
extern "C" {
    pub fn dsymm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        b: *const f64,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut f64,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn dsyrk_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut f64,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn dsyr2k_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const f64,
        lda: *const ::std::os::raw::c_int,
        b: *const f64,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut f64,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn dcabs1_(z: *const Rcomplex) -> f64;
}
extern "C" {
    pub fn dzasum_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn dznrm2_(
        n: *const ::std::os::raw::c_int,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
    ) -> f64;
}
extern "C" {
    pub fn izamax_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn zaxpy_(
        n: *const ::std::os::raw::c_int,
        za: *const Rcomplex,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zcopy_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zdotc_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
    ) -> Rcomplex;
}
extern "C" {
    pub fn zdotu_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
    ) -> Rcomplex;
}
extern "C" {
    pub fn zdrot_(
        n: *const ::std::os::raw::c_int,
        zx: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
        c: *const f64,
        s: *const f64,
    );
}
extern "C" {
    pub fn zdscal_(
        n: *const ::std::os::raw::c_int,
        da: *const f64,
        zx: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zgbmv_(
        trans: *const ::std::os::raw::c_char,
        m: *mut ::std::os::raw::c_int,
        n: *mut ::std::os::raw::c_int,
        kl: *mut ::std::os::raw::c_int,
        ku: *mut ::std::os::raw::c_int,
        alpha: *mut Rcomplex,
        a: *mut Rcomplex,
        lda: *mut ::std::os::raw::c_int,
        x: *mut Rcomplex,
        incx: *mut ::std::os::raw::c_int,
        Rf_beta: *mut Rcomplex,
        y: *mut Rcomplex,
        incy: *mut ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zgemm_(
        transa: *const ::std::os::raw::c_char,
        transb: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        b: *const Rcomplex,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zgemv_(
        trans: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        y: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zgerc_(
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        y: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
        a: *mut Rcomplex,
        lda: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zgeru_(
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        y: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
        a: *mut Rcomplex,
        lda: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zhbmv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        y: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zhemm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        b: *const Rcomplex,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zhemv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        y: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zher_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        a: *mut Rcomplex,
        lda: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zher2_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        y: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
        a: *mut Rcomplex,
        lda: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zher2k_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        b: *const Rcomplex,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zherk_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const f64,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        Rf_beta: *const f64,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zhpmv_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        ap: *const Rcomplex,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        y: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
        arg1: usize,
    );
}
extern "C" {
    pub fn zhpr_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const f64,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        ap: *mut Rcomplex,
        arg1: usize,
    );
}
extern "C" {
    pub fn zhpr2_(
        uplo: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        x: *const Rcomplex,
        incx: *const ::std::os::raw::c_int,
        y: *const Rcomplex,
        incy: *const ::std::os::raw::c_int,
        ap: *mut Rcomplex,
        arg1: usize,
    );
}
extern "C" {
    pub fn zrotg_(ca: *const Rcomplex, cb: *const Rcomplex, c: *mut f64, s: *mut Rcomplex);
}
extern "C" {
    pub fn zscal_(
        n: *const ::std::os::raw::c_int,
        za: *const Rcomplex,
        zx: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zswap_(
        n: *const ::std::os::raw::c_int,
        zx: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        zy: *mut Rcomplex,
        incy: *const ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn zsymm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        b: *const Rcomplex,
        ldb: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zsyr2k_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        alpha: *mut Rcomplex,
        a: *mut Rcomplex,
        lda: *mut ::std::os::raw::c_int,
        b: *mut Rcomplex,
        ldb: *mut ::std::os::raw::c_int,
        Rf_beta: *mut Rcomplex,
        c: *mut Rcomplex,
        ldc: *mut ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn zsyrk_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        Rf_beta: *const Rcomplex,
        c: *mut Rcomplex,
        ldc: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
    );
}
extern "C" {
    pub fn ztbmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn ztbsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        k: *const ::std::os::raw::c_int,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn ztpmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        ap: *const Rcomplex,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn ztpsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        ap: *const Rcomplex,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn ztrmm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        transa: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        m: *const ::std::os::raw::c_int,
        n: *const ::std::os::raw::c_int,
        alpha: *const Rcomplex,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        b: *mut Rcomplex,
        ldb: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
        arg4: usize,
    );
}
extern "C" {
    pub fn ztrmv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
extern "C" {
    pub fn ztrsm_(
        side: *const ::std::os::raw::c_char,
        uplo: *const ::std::os::raw::c_char,
        transa: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        m: *mut ::std::os::raw::c_int,
        n: *mut ::std::os::raw::c_int,
        alpha: *mut Rcomplex,
        a: *mut Rcomplex,
        lda: *mut ::std::os::raw::c_int,
        b: *mut Rcomplex,
        ldb: *mut ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
        arg4: usize,
    );
}
extern "C" {
    pub fn ztrsv_(
        uplo: *const ::std::os::raw::c_char,
        trans: *const ::std::os::raw::c_char,
        diag: *const ::std::os::raw::c_char,
        n: *const ::std::os::raw::c_int,
        a: *const Rcomplex,
        lda: *const ::std::os::raw::c_int,
        x: *mut Rcomplex,
        incx: *const ::std::os::raw::c_int,
        arg1: usize,
        arg2: usize,
        arg3: usize,
    );
}
pub type integr_fn = ::std::option::Option<
    unsafe extern "C" fn(x: *mut f64, n: ::std::os::raw::c_int, ex: *mut ::std::os::raw::c_void),
>;
extern "C" {
    pub fn Rdqags(
        f: integr_fn,
        ex: *mut ::std::os::raw::c_void,
        a: *mut f64,
        b: *mut f64,
        epsabs: *mut f64,
        epsrel: *mut f64,
        result: *mut f64,
        abserr: *mut f64,
        neval: *mut ::std::os::raw::c_int,
        ier: *mut ::std::os::raw::c_int,
        limit: *mut ::std::os::raw::c_int,
        lenw: *mut ::std::os::raw::c_int,
        last: *mut ::std::os::raw::c_int,
        iwork: *mut ::std::os::raw::c_int,
        work: *mut f64,
    );
}
extern "C" {
    pub fn Rdqagi(
        f: integr_fn,
        ex: *mut ::std::os::raw::c_void,
        bound: *mut f64,
        inf: *mut ::std::os::raw::c_int,
        epsabs: *mut f64,
        epsrel: *mut f64,
        result: *mut f64,
        abserr: *mut f64,
        neval: *mut ::std::os::raw::c_int,
        ier: *mut ::std::os::raw::c_int,
        limit: *mut ::std::os::raw::c_int,
        lenw: *mut ::std::os::raw::c_int,
        last: *mut ::std::os::raw::c_int,
        iwork: *mut ::std::os::raw::c_int,
        work: *mut f64,
    );
}
pub type optimfn = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut ::std::os::raw::c_void,
    ) -> f64,
>;
pub type optimgr = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn vmmin(
        n: ::std::os::raw::c_int,
        b: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        maxit: ::std::os::raw::c_int,
        trace: ::std::os::raw::c_int,
        mask: *mut ::std::os::raw::c_int,
        abstol: f64,
        reltol: f64,
        nREPORT: ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        fail: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn nmmin(
        n: ::std::os::raw::c_int,
        Bvec: *mut f64,
        X: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        fail: *mut ::std::os::raw::c_int,
        abstol: f64,
        intol: f64,
        ex: *mut ::std::os::raw::c_void,
        alpha: f64,
        bet: f64,
        gamm: f64,
        trace: ::std::os::raw::c_int,
        fncount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn cgmin(
        n: ::std::os::raw::c_int,
        Bvec: *mut f64,
        X: *mut f64,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        fail: *mut ::std::os::raw::c_int,
        abstol: f64,
        intol: f64,
        ex: *mut ::std::os::raw::c_void,
        type_: ::std::os::raw::c_int,
        trace: ::std::os::raw::c_int,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn lbfgsb(
        n: ::std::os::raw::c_int,
        m: ::std::os::raw::c_int,
        x: *mut f64,
        l: *mut f64,
        u: *mut f64,
        nbd: *mut ::std::os::raw::c_int,
        Fmin: *mut f64,
        fn_: optimfn,
        gr: optimgr,
        fail: *mut ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
        factr: f64,
        pgtol: f64,
        fncount: *mut ::std::os::raw::c_int,
        grcount: *mut ::std::os::raw::c_int,
        maxit: ::std::os::raw::c_int,
        msg: *mut ::std::os::raw::c_char,
        trace: ::std::os::raw::c_int,
        nREPORT: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn samin(
        n: ::std::os::raw::c_int,
        pb: *mut f64,
        yb: *mut f64,
        fn_: optimfn,
        maxit: ::std::os::raw::c_int,
        tmax: ::std::os::raw::c_int,
        ti: f64,
        trace: ::std::os::raw::c_int,
        ex: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn dqrqty_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        qty: *mut f64,
    );
}
extern "C" {
    pub fn dqrqy_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        qy: *mut f64,
    );
}
extern "C" {
    pub fn dqrcf_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        b: *mut f64,
        info: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn dqrrsd_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        rsd: *mut f64,
    );
}
extern "C" {
    pub fn dqrxb_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        k: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        xb: *mut f64,
    );
}
extern "C" {
    pub fn R_pretty(
        lo: *mut f64,
        up: *mut f64,
        ndiv: *mut ::std::os::raw::c_int,
        min_n: ::std::os::raw::c_int,
        shrink_sml: f64,
        high_u_fact: *const f64,
        eps_correction: ::std::os::raw::c_int,
        return_bounds: ::std::os::raw::c_int,
    ) -> f64;
}
pub type fcn_p = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: *mut f64,
        arg3: *mut f64,
        arg4: *mut ::std::os::raw::c_void,
    ),
>;
pub type d2fcn_p = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut f64,
        arg4: *mut f64,
        arg5: *mut ::std::os::raw::c_void,
    ),
>;
extern "C" {
    pub fn fdhess(
        n: ::std::os::raw::c_int,
        x: *mut f64,
        fval: f64,
        fun: fcn_p,
        state: *mut ::std::os::raw::c_void,
        h: *mut f64,
        nfd: ::std::os::raw::c_int,
        step: *mut f64,
        f: *mut f64,
        ndigit: ::std::os::raw::c_int,
        typx: *mut f64,
    );
}
extern "C" {
    pub fn optif9(
        nr: ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
        x: *mut f64,
        fcn: fcn_p,
        d1fcn: fcn_p,
        d2fcn: d2fcn_p,
        state: *mut ::std::os::raw::c_void,
        typsiz: *mut f64,
        fscale: f64,
        method: ::std::os::raw::c_int,
        iexp: ::std::os::raw::c_int,
        msg: *mut ::std::os::raw::c_int,
        ndigit: ::std::os::raw::c_int,
        itnlim: ::std::os::raw::c_int,
        iagflg: ::std::os::raw::c_int,
        iahflg: ::std::os::raw::c_int,
        dlt: f64,
        gradtl: f64,
        stepmx: f64,
        steptl: f64,
        xpls: *mut f64,
        fpls: *mut f64,
        gpls: *mut f64,
        itrmcd: *mut ::std::os::raw::c_int,
        a: *mut f64,
        wrk: *mut f64,
        itncnt: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn dqrdc2_(
        x: *mut f64,
        ldx: *mut ::std::os::raw::c_int,
        n: *mut ::std::os::raw::c_int,
        p: *mut ::std::os::raw::c_int,
        tol: *mut f64,
        rank: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        pivot: *mut ::std::os::raw::c_int,
        work: *mut f64,
    );
}
extern "C" {
    pub fn dqrls_(
        x: *mut f64,
        n: *mut ::std::os::raw::c_int,
        p: *mut ::std::os::raw::c_int,
        y: *mut f64,
        ny: *mut ::std::os::raw::c_int,
        tol: *mut f64,
        b: *mut f64,
        rsd: *mut f64,
        qty: *mut f64,
        k: *mut ::std::os::raw::c_int,
        jpvt: *mut ::std::os::raw::c_int,
        qraux: *mut f64,
        work: *mut f64,
    );
}
pub const RNGtype_WICHMANN_HILL: RNGtype = 0;
pub const RNGtype_MARSAGLIA_MULTICARRY: RNGtype = 1;
pub const RNGtype_SUPER_DUPER: RNGtype = 2;
pub const RNGtype_MERSENNE_TWISTER: RNGtype = 3;
pub const RNGtype_KNUTH_TAOCP: RNGtype = 4;
pub const RNGtype_USER_UNIF: RNGtype = 5;
pub const RNGtype_KNUTH_TAOCP2: RNGtype = 6;
pub const RNGtype_LECUYER_CMRG: RNGtype = 7;
pub type RNGtype = ::std::os::raw::c_uint;
pub const N01type_BUGGY_KINDERMAN_RAMAGE: N01type = 0;
pub const N01type_AHRENS_DIETER: N01type = 1;
pub const N01type_BOX_MULLER: N01type = 2;
pub const N01type_USER_NORM: N01type = 3;
pub const N01type_INVERSION: N01type = 4;
pub const N01type_KINDERMAN_RAMAGE: N01type = 5;
pub type N01type = ::std::os::raw::c_uint;
pub const Sampletype_ROUNDING: Sampletype = 0;
pub const Sampletype_REJECTION: Sampletype = 1;
pub type Sampletype = ::std::os::raw::c_uint;
extern "C" {
    pub fn R_sample_kind() -> Sampletype;
}
extern "C" {
    pub fn GetRNGstate();
}
extern "C" {
    pub fn PutRNGstate();
}
pub type Int32 = ::std::os::raw::c_uint;
extern "C" {
    pub fn user_unif_rand() -> *mut f64;
}
extern "C" {
    pub fn user_unif_init(arg1: Int32);
}
extern "C" {
    pub fn user_unif_nseed() -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn user_unif_seedloc() -> *mut ::std::os::raw::c_int;
}
extern "C" {
    pub fn user_norm_rand() -> *mut f64;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    const UNINIT: ::std::mem::MaybeUninit<__va_list_tag> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gp_offset) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_offset) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overflow_arg_area) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reg_save_area) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
