% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_indices.R
\name{calculate_indices}
\alias{calculate_indices}
\title{Calculate indices from the bands of a raster}
\usage{
calculate_indices(raster, indices, output_filename, ..., names_suffix = NULL)
}
\arguments{
\item{raster}{The raster (either as a SpatRaster or object readable by
\code{\link[terra:rast]{terra::rast()}}) to compute indices from.}

\item{indices}{A data frame of indices to compute. The intent is for this
function to work with subsets of \link{spectral_indices}, but any data frame with
columns \code{formula} (containing a string representation of the equation used
to calculate the index), \code{bands} (a list column containing character vectors
of the necessary bands) and \code{short_name} (which will be used as the band
name) will work.}

\item{output_filename}{The filename to write the computed metrics to.}

\item{...}{These dots are for future extensions and must be empty.}

\item{names_suffix}{If not \code{NULL}, will be used (with \code{\link[=paste]{paste()}}) to add a
suffix to each of the band names returned.}
}
\value{
\code{output_filename}, unchanged.
}
\description{
This function computes any number of indices from an input raster via
\code{\link[terra:predict]{terra::predict()}}. By default, this function is designed to work with
subsets of \code{\link[=spectral_indices]{spectral_indices()}}, but it will work with any data frame with a
\code{formula}, \code{bands}, and \code{short_name} column.
}
\section{Security}{

Note that this function is running code from the \code{formula} column of the
spectral indices data frame, which is derived from a JSON file downloaded off
the internet. It's not impossible that an attacker could take advantage of
this to run arbitrary code on your computer. To mitigate this, indices are
calculated in a minimal environment that contains very few functions or
symbols (preventing an attacker from accessing, for example, \code{system()}).

Still, it's good practice to inspect your \code{formula} column to make sure
there's nothing nasty hiding in any of the formulas you're going to run.
Additionally, consider using pre-saved indices tables or
\code{spectral_indices(download_indices = FALSE)} if using this in an unsupervised
workload.
}

\examples{
calculate_indices(
  system.file("rasters/example_sentinel1.tif", package = "rsi"),
  filter_platforms(platforms = "Sentinel-1 (Dual Polarisation VV-VH)"),
  tempfile(fileext = ".tif"),
  names_suffix = "sentinel1"
)

# Formulas aren't able to access most R functions or operators:
example_indices <- filter_platforms(platforms = "Sentinel-1 (Dual Polarisation VV-VH)")[1, ]
example_indices$formula <- 'system("echo something bad")'
try(
  calculate_indices(
    system.file("rasters/example_sentinel1.tif", package = "rsi"),
    example_indices,
    tempfile(fileext = ".tif")
  )
)

}
