% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{rsi_download_rasters}
\alias{rsi_download_rasters}
\title{Download specific assets from a set of STAC items}
\usage{
rsi_download_rasters(
  items,
  aoi,
  asset_names,
  sign_function = NULL,
  merge = FALSE,
  gdalwarp_options = c("-r", "bilinear", "-multi", "-overwrite", "-co",
    "COMPRESS=DEFLATE", "-co", "PREDICTOR=2", "-co", "NUM_THREADS=ALL_CPUS"),
  gdal_config_options = c(VSI_CACHE = "TRUE", GDAL_CACHEMAX = "30\%", VSI_CACHE_SIZE =
    "10000000", GDAL_HTTP_MULTIPLEX = "YES", GDAL_INGESTED_BYTES_AT_OPEN = "32000",
    GDAL_DISABLE_READDIR_ON_OPEN = "EMPTY_DIR", GDAL_HTTP_VERSION = "2",
    GDAL_HTTP_MERGE_CONSECUTIVE_RANGES = "YES", GDAL_NUM_THREADS = "ALL_CPUS",
    GDAL_HTTP_USERAGENT = "rsi (https://permian-global-research.github.io/rsi/)"),
  ...
)
}
\arguments{
\item{items}{A \code{StacItemCollection} object, as returned by \code{\link[=rsi_query_api]{rsi_query_api()}}.}

\item{aoi}{Either an sf(c) object outlining the area of interest to get
imagery for, or a \code{bbox} image containing the bounding box of your AOI.}

\item{asset_names}{The names of the assets to download. If this vector has
names, then the names of the vector are assumed to be the names of assets on
the STAC server, which will be renamed to the elements of the vector in the
final output.}

\item{sign_function}{A function that takes the output from \code{query_function}
and signs the item URLs, if necessary.}

\item{merge}{Logical: for each asset, should data from multiple items be
merged into a single downloaded file? If \code{TRUE}, this returns a single file
for each asset, which has been merged via gdalwarp. No resampling or
compositing is performed, but rather each pixel uses the last data
downloaded. This is fast, but precludes per-item masking and compositing.
If \code{FALSE}, each asset from each item is saved as a separate file.}

\item{gdalwarp_options}{Options passed to \code{gdalwarp} through the \code{options}
argument of \code{\link[sf:gdal_utils]{sf::gdal_utils()}}. The same set of options are used for all
downloaded data and the final output images; this means that some common
options (for instance, \code{PREDICTOR=3}) may cause errors if bands are of
varying data types.}

\item{gdal_config_options}{Options passed to \code{gdalwarp} through the
\code{config_options} argument of \code{\link[sf:gdal_utils]{sf::gdal_utils()}}.}

\item{...}{Passed to \code{item_filter_function}.}
}
\value{
A data frame  where columns correspond to distinct assets, rows
correspond to distinct items, and cells contain file paths to the downloaded
data.
}
\description{
Download specific assets from a set of STAC items
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aoi <- sf::st_point(c(-74.912131, 44.080410))
aoi <- sf::st_set_crs(sf::st_sfc(aoi), 4326)
aoi <- sf::st_buffer(sf::st_transform(aoi, 5070), 100)

landsat_image <- get_landsat_imagery(
  aoi,
  start_date = "2022-06-01",
  end_date = "2022-08-30",
  download_function = rsi_download_rasters
)

\dontshow{\}) # examplesIf}
}
