% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.multisimsum.R
\name{summary.multisimsum}
\alias{summary.multisimsum}
\title{Summarising multisimsum objects}
\usage{
\method{summary}{multisimsum}(object, ci_level = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{multisimsum}.}

\item{ci_level}{Significance level for confidence intervals based on Monte Carlo standard errors. Ignored if a \code{multisimsum} object is obtained with \code{mcse = FALSE}.}

\item{...}{Ignored.}
}
\value{
An object of class \code{summary.multisimsum}.
}
\description{
The \code{summary()} method for objects of class \code{multisimsum} returns confidence intervals for performance measures based on Monte Carlo standard errors.
}
\note{
Confidence intervals are constructed using quantiles from a normal distribution with the specified \code{ci_level} confidence level, and are therefore symmetric by definition.
}
\examples{
data(frailty)
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50,
   fv = 0.75), estvarname = "b", se = "se", methodvar = "model",
   by = "fv_dist")
sms <- summary(ms)
sms
}
\seealso{
\code{\link[=multisimsum]{multisimsum()}}, \code{\link[=print.summary.multisimsum]{print.summary.multisimsum()}}
}
