% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropbig.simsum.R
\name{dropbig.simsum}
\alias{dropbig.simsum}
\title{Return observations dropped by simsum}
\usage{
\method{dropbig}{simsum}(x, ...)
}
\arguments{
\item{x}{An object of class \code{simsum}.}

\item{...}{Ignored.}
}
\value{
An object of class \code{dropbig.simsum} if \code{dropbig} was set to \code{TRUE} when calling \code{simsum}, \code{NULL} otherwise. It contains two slots: \code{big_estvarname} and \code{big_se}. Both slots consist in the portion of the original data that was identified to have estimated values or standard errors exceeding the limits defined by \code{max} and \code{semax}.
}
\description{
\code{dropbig.simsum} returns observations dropped by simsum while computing summary statistics for a simulation study.
}
\examples{
data("MIsim")
x <- simsum(data = MIsim, estvarname = "b", true = 0.5, se = "se",
            methodvar = "method", mcse = TRUE,
dropbig = TRUE, max = 3, semax = 1.5)
d <- dropbig(x)
d
}
\seealso{
\code{\link[=simsum]{simsum()}}, \code{\link[=print.dropbig.simsum]{print.dropbig.simsum()}}
}
