% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinaica_station_params_and_dates.R
\name{sinaica_station_dates}
\alias{sinaica_station_dates}
\title{Dates supported by a station}
\usage{
sinaica_station_dates(station_id, type = "Crude")
}
\arguments{
\item{station_id}{the numeric code corresponding to each station. See
\code{\link{stations_sinaica}} for a list of stations and their ids.}

\item{type}{The type of data to download. One of the following:
\itemize{
\item{"Crude"}{ - Crude data that has not been validated}
\item{"Validated"}{ - Validated data (may not be the most up-to-date)}
\item{"Manual"}{ - Manual data}
}}
}
\value{
a vector containing the date the station started reporting
and end reporting date
}
\description{
Start date and end date of the range for which SINAICA has data for an air quality station
}
\examples{
## id 271 is Xalostoc. See `stations_sinaica`
df <- sinaica_station_dates(271, "Manual")
head(df)
}
