% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eeg.R
\name{bands_power}
\alias{bands_power}
\title{Computes spectral power of bands listed in the bands argument.}
\usage{
bands_power(bands, signal, sRate, broadband = c(0.5, 40))
}
\arguments{
\item{bands}{A list of bands to compute with lower and upper limits in the form `list(c(0,4),c(4,8))``}

\item{signal}{Numerical vector of the signal.}

\item{sRate}{Signal sample rate in Hertz.}

\item{broadband}{The broadband to normalize by.}
}
\value{
A list of bands powers.
}
\description{
`bands_power` calculates power spectral densities estimates using Welch's method on bands. Bands are computed from spectrogram bands equal or greater than lower limit and inferior to the upper limit.
}
\examples{
bands_power(bands = list(c(0,4),c(4,8)),signal = sin(c(1:10000)),sRate = 200)
}
