% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{normalize_cycles}
\alias{normalize_cycles}
\title{Normalize sleep cycles scored on Noxturnal software from start and stop flags to unique events.}
\usage{
normalize_cycles(events)
}
\arguments{
\item{events}{Events dataframe. Dataframe must have \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event}. Cycles flags must be named \code{Activity-CLASSICstart}, \code{Activity-BNstart}, \code{Activity-BNend}, \code{Activity-REMstart}, \code{Activity-REMend}, \code{Activity-ENstart} or \code{Activity-ENend}.}
}
\description{
Normalize sleep cycles scored on Noxturnal software from start and stop flags to unique events.
}
\examples{
cycles <- data.frame(event = c("Activity-CLASSICstart","Activity-CLASSICend"))
cycles$begin <- as.POSIXct(c("2016-01-16 01:13:30","2016-01-16 01:15:30"))
cycles$end <- as.POSIXct(c("2016-01-16 01:13:30","2016-01-16 01:15:30"))
normalize_cycles(cycles)
}
