% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slurm_job.R
\name{slurm_job}
\alias{slurm_job}
\title{Create a slurm_job object}
\usage{
slurm_job(jobname, nodes)
}
\arguments{
\item{jobname}{The name of the Slurm job. The rslurm-generated scripts and 
output files associated with a job should be found in the 
\emph{_rslurm_[jobname]} folder.}

\item{nodes}{The number of cluster nodes used by that job.}
}
\value{
A \code{slurm_job} object.
}
\description{
This function creates a \code{slurm_job} object which can be passed to other
functions such as \code{\link{cancel_slurm}}, \code{\link{cleanup_files}}, 
\code{\link{get_slurm_out}} and \code{\link{print_job_status}}.
}
\details{
In general, \code{slurm_job} objects are created automatically as the output of 
\code{\link{slurm_apply}} or \code{\link{slurm_call}}, but it may be necessary 
to manually recreate one if the job was submitted in a different R session.
}
