#---- Helper functions (internal) ----
sss <- function(n, k, g) {
  g / (g - 1L) * (n - 1L) / (n - k)
}

#---- Variance matrix ----
rs_var <- function(u, Z, X = Z, ids = seq_len(nrow(X)), df = NULL) {
  ids <- as.factor(ids)
  df <- if (is.null(df)) {
    sss(nrow(X), ncol(X), nlevels(ids))
  } else {
    as.numeric(df)
  }
  # the meat
  ug <- split.data.frame(u, ids)
  Zg <- split.data.frame(Z, ids)
  V <- Map(function(x, y) tcrossprod(crossprod(x, y)), Zg, ug)
  V <- Reduce(`+`, V)
  # the bread
  B <- solve(crossprod(Z, X))
  # put the sandwich together
  vcov <- tcrossprod(B %*% V, B)
  df * vcov
}
