% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-oni.R
\name{download_oni}
\alias{download_oni}
\title{Download Oceanic Nino Index data}
\usage{
download_oni(use_cache = FALSE, file = NULL)
}
\arguments{
\item{use_cache}{logical option to save and load from cache. If `TRUE`, results will be cached in memory
if `file` is `NULL` or on disk if `file` is not `NULL`.}

\item{file}{optional character with the full path of a file to save the data. If `cache` is `FALSE` but
`file` is not `NULL`, the results will be downloaded from the internet and saved on disk.}
}
\value{
\itemize{
\item Date: Date object that uses the first of the month as a placeholder. Date formatted as date on the first of the month because R only supports one partial of date time
\item Month: Month of record
\item Year: Year of record
\item ONI: Oneanic Oscillation Index
\item ONI_month_window: 3 month period over which the Oneanic Oscillation Index is calculated
\item phase: ENSO phase  
}
}
\description{
The Oceanic Nino Index is average sea surface temperature in the Nino 3.4 region (120W to 170W) averaged over three months. Phases are categorized by Oceanic Nino Index:
\itemize{
\item Warm phase of El Nino/ Southern Oscillation when 3-month average sea-surface temperature departure of positive 0.5 degC
\item Cool phase of La Nina/ Southern Oscillation when 3-month average sea-surface temperature departure of negative 0.5 degC
\item Neutral phase is defined as when the three month temperature average is between +0.5 and -0.5 degC
}
}
\examples{
\dontrun{
oni <- download_oni()
}

}
\references{
\url{http://www.cpc.ncep.noaa.gov/products/analysis_monitoring/ensostuff/detrend.nino34.ascii.txt}
}
